/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.kdiff.diff.visitors;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pw.prok.kdiff.Chunk;
import pw.prok.kdiff.Pair;
import pw.prok.kdiff.Patch;
import pw.prok.kdiff.PatchResult;
import pw.prok.kdiff.delta.ChangeDelta;
import pw.prok.kdiff.diff.DiffException;
import pw.prok.kdiff.diff.DiffRow;
import pw.prok.kdiff.diff.DiffVisitor;

public class MappedVisitor<T, C>
implements DiffVisitor<T, C> {
    private final Map<Pair<String, String>, Patch<T, PatchResult<T>>> map;
    protected String originalFilename;
    protected Date originalDate;
    protected String revisedFilename;
    protected Date revisedDate;
    final List<T> oldLines = new ArrayList<T>();
    final List<T> newLines = new ArrayList<T>();

    public MappedVisitor() {
        this(new HashMap<Pair<String, String>, Patch<T, PatchResult<T>>>());
    }

    public MappedVisitor(Map<Pair<String, String>, Patch<T, PatchResult<T>>> map) {
        this.map = map;
    }

    public Map<Pair<String, String>, Patch<T, PatchResult<T>>> getMap() {
        return this.map;
    }

    @Override
    public boolean visitComment(C comment) {
        return true;
    }

    @Override
    public boolean visitOriginal(String original, Date date) throws DiffException {
        this.originalFilename = original;
        this.originalDate = date;
        return true;
    }

    @Override
    public boolean visitRevised(String revised, Date date) throws DiffException {
        this.revisedFilename = revised;
        this.revisedDate = date;
        return true;
    }

    @Override
    public boolean visitChunkStart(int originalPosition, int originalCount, int revisedPosition, int revisedCount) {
        return true;
    }

    @Override
    public boolean visitChunkEnd(int originalPosition, int originalCount, int revisedPosition, int revisedCount) {
        Chunk<T> original = new Chunk<T>(originalPosition - 1, new ArrayList<T>(this.oldLines));
        Chunk<T> revised = new Chunk<T>(revisedPosition - 1, new ArrayList<T>(this.newLines));
        this.oldLines.clear();
        this.newLines.clear();
        Pair.ImmutablePair<String, String> key = Pair.immutable(this.originalFilename, this.revisedFilename);
        Patch<T, PatchResult<Object>> patch = this.map.get(key);
        if (patch == null) {
            patch = new Patch();
            this.map.put(key, patch);
            patch.setOriginal(this.originalFilename);
            patch.setOriginalDate(this.originalDate);
            patch.setRevised(this.revisedFilename);
            patch.setRevisedDate(this.revisedDate);
        }
        patch.addDelta(new ChangeDelta<T>(original, revised));
        return true;
    }

    @Override
    public boolean visitLine(DiffRow.Tag tag, T line) {
        switch (tag) {
            case INSERT: {
                this.newLines.add(line);
                return true;
            }
            case DELETE: {
                this.oldLines.add(line);
                return true;
            }
        }
        this.oldLines.add(line);
        this.newLines.add(line);
        return true;
    }
}

