/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.kdiff.diff;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import pw.prok.kdiff.Chunk;
import pw.prok.kdiff.Pair;
import pw.prok.kdiff.Patch;
import pw.prok.kdiff.PatchFailedException;
import pw.prok.kdiff.PatchResult;
import pw.prok.kdiff.delta.ChangeDelta;
import pw.prok.kdiff.delta.Delta;
import pw.prok.kdiff.diff.DiffAlgorithm;
import pw.prok.kdiff.diff.DiffException;
import pw.prok.kdiff.diff.DiffVisitor;
import pw.prok.kdiff.diff.parsers.UnifedDiffParser;
import pw.prok.kdiff.diff.visitors.MappedVisitor;
import pw.prok.kdiff.diff.visitors.SimpleVisitor;
import pw.prok.kdiff.myers.Equalizer;
import pw.prok.kdiff.myers.MyersDiff;

public class DiffUtils {
    private static Pattern unifiedDiffChunkRe = Pattern.compile("^@@\\s+-(?:(\\d+)(?:,(\\d+))?)\\s+\\+(?:(\\d+)(?:,(\\d+))?)\\s+@@$");

    public static <T, R extends PatchResult<T>> Patch<T, R> diff(List<T> original, List<T> revised) {
        return DiffUtils.diff(original, revised, new MyersDiff());
    }

    public static <T, R extends PatchResult<T>> Patch<T, R> diff(List<T> original, List<T> revised, Equalizer<T> equalizer) {
        if (equalizer != null) {
            return DiffUtils.diff(original, revised, new MyersDiff(equalizer));
        }
        return DiffUtils.diff(original, revised, new MyersDiff());
    }

    public static <T, R extends PatchResult<T>> Patch<T, R> diff(List<T> original, List<T> revised, DiffAlgorithm<T, R> algorithm) {
        if (original == null) {
            throw new IllegalArgumentException("original must not be null");
        }
        if (revised == null) {
            throw new IllegalArgumentException("revised must not be null");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm must not be null");
        }
        return algorithm.diff(original, revised);
    }

    public static <T, R extends PatchResult<T>> R patch(List<T> original, Patch<T, R> patch) throws PatchFailedException {
        return patch.applyTo(original);
    }

    public static <T, R extends PatchResult<T>> R restore(List<T> revised, Patch<T, R> patch) {
        return patch.restore(revised);
    }

    public static Patch<String, PatchResult<String>> parseDiff(List<String> diff) throws DiffException {
        SimpleVisitor visitor = new SimpleVisitor();
        UnifedDiffParser.INSTANCE.parse(diff, (DiffVisitor<String, String>)visitor);
        return visitor.getPatch();
    }

    public static Map<Pair<String, String>, Patch<String, PatchResult<String>>> parseUnifedDiff(List<String> diff) throws DiffException {
        MappedVisitor visitor = new MappedVisitor();
        UnifedDiffParser.INSTANCE.parse(diff, (DiffVisitor<String, String>)visitor);
        return visitor.getMap();
    }

    public static Map<Pair<String, String>, Patch<String, PatchResult<String>>> parseUnifedDiff(List<String> diff, Map<Pair<String, String>, Patch<String, PatchResult<String>>> map) throws DiffException {
        MappedVisitor visitor = new MappedVisitor(map);
        UnifedDiffParser.INSTANCE.parse(diff, (DiffVisitor<String, String>)visitor);
        return visitor.getMap();
    }

    private static <R extends PatchResult<String>> void processLine(List<String[]> rawChunk, Patch<String, R> patch, int old_ln, int new_ln) {
        if (rawChunk.size() != 0) {
            ArrayList<String> oldChunkLines = new ArrayList<String>();
            ArrayList<String> newChunkLines = new ArrayList<String>();
            for (String[] raw_line : rawChunk) {
                String tag = raw_line[0];
                String rest = raw_line[1];
                if (tag.equals(" ") || tag.equals("-")) {
                    oldChunkLines.add(rest);
                }
                if (!tag.equals(" ") && !tag.equals("+")) continue;
                newChunkLines.add(rest);
            }
            patch.addDelta(new ChangeDelta(new Chunk(old_ln - 1, oldChunkLines), new Chunk(new_ln - 1, newChunkLines)));
            rawChunk.clear();
        }
    }

    public static List<String> makeDiff(String original, String revised, List<String> originalLines, Patch<String, ?> patch, int contextSize) {
        if (!patch.getDeltas().isEmpty()) {
            ArrayList<String> ret = new ArrayList<String>();
            ret.add("--- " + original);
            ret.add("+++ " + revised);
            ArrayList<Delta<String>> patchDeltas = new ArrayList<Delta<String>>(patch.getDeltas());
            ArrayList<Delta<String>> deltas = new ArrayList<Delta<String>>();
            Delta delta = (Delta)patchDeltas.get(0);
            deltas.add(delta);
            if (patchDeltas.size() > 1) {
                for (int i = 1; i < patchDeltas.size(); ++i) {
                    int position = delta.getOriginal().getPosition();
                    Delta nextDelta = (Delta)patchDeltas.get(i);
                    if (position + delta.getOriginal().size() + contextSize >= nextDelta.getOriginal().getPosition() - contextSize) {
                        deltas.add(nextDelta);
                    } else {
                        List<String> curBlock = DiffUtils.processDeltas(originalLines, deltas, contextSize);
                        ret.addAll(curBlock);
                        deltas.clear();
                        deltas.add(nextDelta);
                    }
                    delta = nextDelta;
                }
            }
            List<String> curBlock = DiffUtils.processDeltas(originalLines, deltas, contextSize);
            ret.addAll(curBlock);
            return ret;
        }
        return new ArrayList<String>();
    }

    private static List<String> processDeltas(List<String> origLines, List<Delta<String>> deltas, int contextSize) {
        int line;
        int contextStart;
        int revStart;
        ArrayList<String> buffer = new ArrayList<String>();
        int origTotal = 0;
        int revTotal = 0;
        Delta<String> curDelta = deltas.get(0);
        int origStart = curDelta.getOriginal().getPosition() + 1 - contextSize;
        if (origStart < 1) {
            origStart = 1;
        }
        if ((revStart = curDelta.getRevised().getPosition() + 1 - contextSize) < 1) {
            revStart = 1;
        }
        if ((contextStart = curDelta.getOriginal().getPosition() - contextSize) < 0) {
            contextStart = 0;
        }
        for (line = contextStart; line < curDelta.getOriginal().getPosition(); ++line) {
            buffer.add(" " + origLines.get(line));
            ++origTotal;
            ++revTotal;
        }
        buffer.addAll(DiffUtils.getDeltaText(curDelta));
        origTotal += curDelta.getOriginal().getLines().size();
        revTotal += curDelta.getRevised().getLines().size();
        for (int deltaIndex = 1; deltaIndex < deltas.size(); ++deltaIndex) {
            int intermediateStart;
            Delta<String> nextDelta = deltas.get(deltaIndex);
            for (line = intermediateStart = curDelta.getOriginal().getPosition() + curDelta.getOriginal().getLines().size(); line < nextDelta.getOriginal().getPosition(); ++line) {
                buffer.add(" " + origLines.get(line));
                ++origTotal;
                ++revTotal;
            }
            buffer.addAll(DiffUtils.getDeltaText(nextDelta));
            origTotal += nextDelta.getOriginal().getLines().size();
            revTotal += nextDelta.getRevised().getLines().size();
            curDelta = nextDelta;
        }
        for (line = contextStart = curDelta.getOriginal().getPosition() + curDelta.getOriginal().getLines().size(); line < contextStart + contextSize && line < origLines.size(); ++line) {
            buffer.add(" " + origLines.get(line));
            ++origTotal;
            ++revTotal;
        }
        StringBuffer header = new StringBuffer();
        header.append("@@ -");
        header.append(origStart);
        header.append(",");
        header.append(origTotal);
        header.append(" +");
        header.append(revStart);
        header.append(",");
        header.append(revTotal);
        header.append(" @@");
        buffer.add(0, header.toString());
        return buffer;
    }

    private static List<String> getDeltaText(Delta<String> delta) {
        ArrayList<String> buffer = new ArrayList<String>();
        for (String line : delta.getOriginal().getLines()) {
            buffer.add("-" + line);
        }
        for (String line : delta.getRevised().getLines()) {
            buffer.add("+" + line);
        }
        return buffer;
    }
}

