/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.kdiff.delta;

import java.util.List;
import pw.prok.kdiff.Chunk;
import pw.prok.kdiff.PatchFailedException;
import pw.prok.kdiff.delta.Delta;

public class DeleteDelta<T>
extends Delta<T> {
    public DeleteDelta(Chunk<T> original, Chunk<T> revised) {
        super(original, revised);
    }

    @Override
    public void applyTo(List<T> target) throws PatchFailedException {
        this.verify(target);
        int position = this.getOriginal().getPosition();
        int size = this.getOriginal().size();
        for (int i = 0; i < size; ++i) {
            target.remove(position);
        }
    }

    @Override
    public void restore(List<T> target) {
        int position = this.getRevised().getPosition();
        List lines = this.getOriginal().getLines();
        for (int i = 0; i < lines.size(); ++i) {
            target.add(position + i, lines.get(i));
        }
    }

    @Override
    public Delta.DeltaType getType() {
        return Delta.DeltaType.DELETE;
    }

    @Override
    public void verify(List<T> target) throws PatchFailedException {
        this.getOriginal().verify(target);
    }

    public String toString() {
        return "[DeleteDelta, position: " + this.getOriginal().getPosition() + ", lines: " + this.getOriginal().getLines() + "]";
    }

    @Override
    public DeleteDelta<T> copy() {
        return new DeleteDelta(this.getOriginal().copy(), this.getRevised().copy());
    }
}

