/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.kdiff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import pw.prok.kdiff.PatchFailedException;
import pw.prok.kdiff.PatchResult;
import pw.prok.kdiff.delta.Delta;
import pw.prok.kdiff.delta.DeltaComparator;

public class Patch<T, R extends PatchResult<T>> {
    private String original;
    private Date originalDate;
    private String revised;
    private Date revisedDate;
    private final List<Delta<T>> deltas;

    public Patch() {
        this(new ArrayList<Delta<T>>());
    }

    public Patch(List<Delta<T>> deltas) {
        this.deltas = deltas;
    }

    protected R createResult(List<T> result) {
        return (R)new PatchResult<T>(result);
    }

    public R applyTo(List<T> target) throws PatchFailedException {
        LinkedList<T> result = new LinkedList<T>(target);
        ListIterator<Delta<T>> it = this.getDeltas().listIterator(this.deltas.size());
        while (it.hasPrevious()) {
            Delta<T> delta = it.previous();
            delta.applyTo(result);
        }
        return this.createResult(result);
    }

    public R restore(List<T> target) {
        LinkedList<T> result = new LinkedList<T>(target);
        ListIterator<Delta<T>> it = this.getDeltas().listIterator(this.deltas.size());
        while (it.hasPrevious()) {
            Delta<T> delta = it.previous();
            delta.restore(result);
        }
        return this.createResult(result);
    }

    public void addDelta(Delta<T> delta) {
        this.deltas.add(delta);
    }

    public List<Delta<T>> getDeltas() {
        Collections.sort(this.deltas, DeltaComparator.INSTANCE);
        return this.deltas;
    }

    protected Patch<T, R> createEmpty(List<Delta<T>> deltas) {
        return new Patch<T, R>(deltas);
    }

    public Patch<T, R> copy() {
        Patch<T, R> patch = this.createEmpty(new ArrayList<Delta<T>>(this.deltas.size()));
        patch.original = this.original;
        patch.originalDate = this.originalDate;
        patch.revised = this.revised;
        patch.revisedDate = this.revisedDate;
        for (Delta<T> delta : this.getDeltas()) {
            patch.addDelta(delta.copy());
        }
        return patch;
    }

    public Patch<T, R> mergeSelf(Patch<T, R> patch) {
        List<Delta<T>> deltas = patch.deltas;
        if (this.deltas instanceof ArrayList) {
            ((ArrayList)this.deltas).ensureCapacity(this.deltas.size() + deltas.size());
        }
        for (Delta<T> delta : deltas) {
            this.deltas.add(delta.copy());
        }
        return this;
    }

    public Patch<T, R> merge(Patch<T, R> patch) {
        return this.copy().mergeSelf(patch);
    }

    public String getOriginal() {
        return this.original;
    }

    public Patch<T, R> setOriginal(String original) {
        this.original = original;
        return this;
    }

    public Date getOriginalDate() {
        return this.originalDate;
    }

    public Patch setOriginalDate(Date originalDate) {
        this.originalDate = originalDate;
        return this;
    }

    public String getRevised() {
        return this.revised;
    }

    public Patch<T, R> setRevised(String revised) {
        this.revised = revised;
        return this;
    }

    public Date getRevisedDate() {
        return this.revisedDate;
    }

    public Patch setRevisedDate(Date revisedDate) {
        this.revisedDate = revisedDate;
        return this;
    }
}

