package pw.prok.kdiff.diff.visitors;

import pw.prok.kdiff.Patch;
import pw.prok.kdiff.PatchResult;
import pw.prok.kdiff.diff.DiffException;

import java.util.Collection;
import java.util.Date;

public class SimpleVisitor<T, C> extends MappedVisitor<T, C> {
    boolean originalVisited = false, revisedVisited = false;

    @Override
    public boolean visitOriginal(String original, Date date) throws DiffException {
        System.out.println("ORIGINAL: " + original + " " + date);
        if (originalVisited && !originalFilename.equals(original))
            throw new DiffException("Original name already visited!");
        originalVisited = true;
        return super.visitOriginal(original, date);
    }

    @Override
    public boolean visitRevised(String revised, Date date) throws DiffException {
        System.out.println("REVISED: " + revised + " " + date);
        if (revisedVisited && !revisedFilename.equals(revised))
            throw new DiffException("Revised name already visited!");
        revisedVisited = true;
        return super.visitRevised(revised, date);
    }

    public Patch<T, PatchResult<T>> getPatch() {
        final Collection<Patch<T, PatchResult<T>>> values = getMap().values();
        if (values.size() > 1) {
            throw new RuntimeException(new DiffException("What? More than one patch? Seriously?"));
        }
        for (Patch<T, PatchResult<T>> patch : values) return patch;
        return new Patch<>();
    }
}
