/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.download;

import groovy.lang.Closure;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import pw.prok.download.VerifySpec;

public class VerifyAction
implements VerifySpec {
    private final Project project;
    private File src;
    private String algorithm = "MD5";
    private String checksum;

    public VerifyAction(Project project) {
        this.project = project;
    }

    private String toHex(byte[] barr) {
        StringBuffer result = new StringBuffer();
        for (byte b : barr) {
            result.append(String.format("%02X", b));
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws IOException, NoSuchAlgorithmException {
        String calculatedChecksum;
        if (this.src == null) {
            throw new IllegalArgumentException("Please provide a file to verify");
        }
        if (this.algorithm == null) {
            throw new IllegalArgumentException("Please provide the algorithm to use to calculate the checksum");
        }
        if (this.checksum == null) {
            throw new IllegalArgumentException("Please provide a checksum to verify against");
        }
        MessageDigest md = MessageDigest.getInstance(this.algorithm);
        FileInputStream fis = new FileInputStream(this.src);
        try {
            byte[] buf = new byte[1024];
            int read = 0;
            while ((read = fis.read(buf)) != -1) {
                md.update(buf, 0, read);
            }
            calculatedChecksum = this.toHex(md.digest());
        }
        finally {
            fis.close();
        }
        if (!calculatedChecksum.equalsIgnoreCase(this.checksum)) {
            throw new GradleException("Invalid checksum for file '" + this.src.getName() + "'. Expected " + this.checksum.toLowerCase() + " but got " + calculatedChecksum.toLowerCase() + ".");
        }
    }

    @Override
    public void src(Object src) {
        if (src instanceof Closure) {
            Closure closure = (Closure)src;
            src = closure.call();
        }
        if (src instanceof CharSequence) {
            src = this.project.file((Object)src.toString());
        }
        if (!(src instanceof File)) {
            throw new IllegalArgumentException("Verification source must either be a CharSequence or a File");
        }
        this.src = (File)src;
    }

    @Override
    public void algorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public void checksum(String checksum) {
        this.checksum = checksum;
    }

    @Override
    public File getSrc() {
        return this.src;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getChecksum() {
        return this.checksum;
    }
}

