/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.download;

import groovy.lang.Closure;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpDateGenerator;
import org.apache.http.util.EntityUtils;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import pw.prok.download.DownloadSpec;
import pw.prok.download.internal.InsecureHostnameVerifier;
import pw.prok.download.internal.InsecureTrustManager;

public class DownloadAction
implements DownloadSpec {
    private static final HostnameVerifier INSECURE_HOSTNAME_VERIFIER = new InsecureHostnameVerifier();
    private static final TrustManager[] INSECURE_TRUST_MANAGERS = new TrustManager[]{new InsecureTrustManager()};
    private final Project project;
    private List<URL> sources = new ArrayList<URL>(1);
    private File dest;
    private boolean quiet = false;
    private boolean overwrite = true;
    private boolean onlyIfNewer = false;
    private boolean compress = true;
    private String username;
    private String password;
    private Map<String, String> headers;
    private boolean acceptAnyCertificate = false;
    private AtomicInteger upToDate = new AtomicInteger(0);
    private AtomicInteger skipped = new AtomicInteger(0);
    private SSLConnectionSocketFactory insecureSSLSocketFactory = null;
    private long cache = 0L;
    private int maxDownloadThreads = 1;

    public DownloadAction(Project project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws IOException {
        if (this.sources.isEmpty()) {
            throw new IllegalArgumentException("Please provide a download source");
        }
        if (this.dest == null) {
            throw new IllegalArgumentException("Please provide a download destination");
        }
        if (this.dest.equals(this.project.getBuildDir())) {
            this.dest.mkdirs();
        }
        if (this.sources.size() > 1 && !this.dest.isDirectory()) {
            if (this.dest.exists()) throw new IllegalArgumentException("If multiple sources are provided the destination has to be a directory.");
            this.dest.mkdirs();
        }
        CloseableHttpClient client = this.createHttpClient();
        ExecutorService executors = Executors.newFixedThreadPool(this.maxDownloadThreads);
        ArrayList futures = new ArrayList();
        try {
            for (URL uRL : this.sources) {
                Future<?> future = this.execute(client, executors, uRL);
                if (future == null) continue;
                futures.add(future);
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    throw new IOException(e);
                    return;
                }
            }
        }
        finally {
            executors.shutdown();
        }
    }

    private Future<?> execute(CloseableHttpClient client, ExecutorService executors, URL src) throws IOException {
        File destFile = this.destFile(src);
        if (this.project.getGradle().getStartParameter().isOffline()) {
            if (destFile.exists()) {
                if (!this.quiet) {
                    this.project.getLogger().info("Skipping existing file '" + destFile.getName() + "' in offline mode.");
                }
                this.skipped.incrementAndGet();
                return null;
            }
            throw new IllegalStateException("Unable to download " + src + " in offline mode.");
        }
        if (!this.overwrite && destFile.exists()) {
            if (!this.quiet) {
                this.project.getLogger().info("Destination file already exists. Skipping '" + destFile.getName() + "'");
            }
            this.upToDate.incrementAndGet();
            return null;
        }
        if (this.cache > 0L && System.currentTimeMillis() - destFile.lastModified() > this.cache) {
            if (!this.quiet) {
                this.project.getLogger().info("File '" + destFile.getName() + "' not expired cache period.");
            }
            this.upToDate.incrementAndGet();
            return null;
        }
        return executors.submit(new Downloader(client, src, destFile));
    }

    private File destFile(URL src) {
        File destFile = this.dest;
        if (destFile.isDirectory()) {
            String name = src.toString();
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            name = name.substring(name.lastIndexOf(47) + 1);
            destFile = new File(this.dest, name);
        } else {
            File parent = destFile.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
        }
        return destFile;
    }

    private HttpHost configureProxy(HttpHost httpHost) throws IOException {
        HttpHost proxy = null;
        String scheme = httpHost.getSchemeName();
        if (!("http".equals(scheme) || "https".equals(scheme) || "ftp".equals(scheme))) {
            return null;
        }
        String host = System.getProperty(scheme + ".proxyHost");
        if (host != null) {
            String portStr = System.getProperty(scheme + ".proxyPort");
            if (portStr != null) {
                int port;
                try {
                    port = Integer.parseInt(portStr);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal proxy port: " + portStr);
                }
                proxy = new HttpHost(host, port);
            } else {
                proxy = new HttpHost(host);
            }
        }
        return proxy;
    }

    private CloseableHttpClient createHttpClient() {
        PoolingHttpClientConnectionManager connectionManager;
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (this.acceptAnyCertificate) {
            SSLConnectionSocketFactory icsf = this.getInsecureSSLSocketFactory();
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)icsf);
            Registry registry = RegistryBuilder.create().register("https", (Object)icsf).build();
            connectionManager = new PoolingHttpClientConnectionManager(registry);
        } else {
            connectionManager = new PoolingHttpClientConnectionManager();
        }
        builder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        return builder.build();
    }

    private CloseableHttpResponse openConnection(HttpHost httpHost, String file, long timestamp, CloseableHttpClient client) throws IOException {
        CloseableHttpResponse response;
        int n;
        HttpClientContext context = null;
        if (this.username != null && this.password != null) {
            context = HttpClientContext.create();
            this.addAuthentication(httpHost, this.username, this.password, true, context);
        }
        HttpGet get = new HttpGet(file);
        HttpHost proxy = this.configureProxy(httpHost);
        if (proxy != null) {
            RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
            get.setConfig(config);
            String string = httpHost.getSchemeName();
            String proxyUser = System.getProperty(string + ".proxyUser");
            String proxyPassword = System.getProperty(string + ".proxyPassword");
            if (proxyUser != null && proxyPassword != null) {
                if (context == null) {
                    context = HttpClientContext.create();
                }
                this.addAuthentication(proxy, proxyUser, proxyPassword, false, context);
            }
        }
        if (timestamp > 0L) {
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            format.setTimeZone(HttpDateGenerator.GMT);
            get.setHeader("If-Modified-Since", format.format(timestamp));
        }
        if (this.headers != null) {
            for (Map.Entry entry : this.headers.entrySet()) {
                get.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.compress) {
            get.setHeader("Accept-Encoding", "gzip");
        }
        if (((n = (response = client.execute(httpHost, (HttpRequest)get, (HttpContext)context)).getStatusLine().getStatusCode()) < 200 || n > 299) && n != 304) {
            throw new ClientProtocolException(response.getStatusLine().getReasonPhrase());
        }
        return response;
    }

    private void addAuthentication(HttpHost host, String username, String password, boolean preAuthenticate, HttpClientContext context) {
        CredentialsProvider credsProvider;
        AuthCache authCache = context.getAuthCache();
        if (authCache == null) {
            authCache = new BasicAuthCache();
            context.setAuthCache(authCache);
        }
        if ((credsProvider = context.getCredentialsProvider()) == null) {
            credsProvider = new BasicCredentialsProvider();
            context.setCredentialsProvider(credsProvider);
        }
        credsProvider.setCredentials(new AuthScope(host), (Credentials)new UsernamePasswordCredentials(username, password));
        if (preAuthenticate) {
            authCache.put(host, (AuthScheme)new BasicScheme());
        }
    }

    private String toLengthText(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return bytes / 1024L + " KB";
        }
        if (bytes < 0x40000000L) {
            return String.format("%.2f MB", (double)bytes / 1048576.0);
        }
        return String.format("%.2f GB", (double)bytes / 1.073741824E9);
    }

    private long parseLastModified(HttpResponse response) {
        Header header = response.getLastHeader("Last-Modified");
        if (header == null) {
            return 0L;
        }
        String value = header.getValue();
        if (value == null || value.isEmpty()) {
            return 0L;
        }
        Date date = DateUtils.parseDate((String)value);
        if (date == null) {
            return 0L;
        }
        return date.getTime();
    }

    private boolean isContentCompressed(HttpEntity entity) {
        Header header = entity.getContentEncoding();
        if (header == null) {
            return false;
        }
        String value = header.getValue();
        if (value == null || value.isEmpty()) {
            return false;
        }
        return value.equalsIgnoreCase("gzip");
    }

    boolean isUpToDate() {
        return this.upToDate.get() == this.sources.size();
    }

    boolean isSkipped() {
        return this.skipped.get() == this.sources.size();
    }

    List<File> getOutputFiles() {
        ArrayList<File> files = new ArrayList<File>(this.sources.size());
        for (URL src : this.sources) {
            files.add(this.destFile(src));
        }
        return files;
    }

    @Override
    public void src(Object src) throws MalformedURLException {
        if (src instanceof Closure) {
            Closure closure = (Closure)src;
            src = closure.call();
        }
        if (src instanceof CharSequence) {
            this.sources.add(new URL(src.toString()));
        } else if (src instanceof URL) {
            this.sources.add((URL)src);
        } else if (src instanceof Collection) {
            Collection sc = (Collection)src;
            for (Object sco : sc) {
                this.src(sco);
            }
        } else if (src != null && src.getClass().isArray()) {
            int len = Array.getLength(src);
            for (int i = 0; i < len; ++i) {
                Object sco = Array.get(src, i);
                this.src(sco);
            }
        } else {
            throw new IllegalArgumentException("Download source must either be a URL, a CharSequence, a Collection or an array.");
        }
    }

    @Override
    public void dest(Object dest) {
        if (dest instanceof Closure) {
            Closure closure = (Closure)dest;
            dest = closure.call();
        }
        if (dest instanceof CharSequence) {
            this.dest = this.project.file((Object)dest.toString());
        } else if (dest instanceof File) {
            this.dest = (File)dest;
        } else {
            throw new IllegalArgumentException("Download destination must either be a File or a CharSequence");
        }
    }

    @Override
    public void quiet(boolean quiet) {
        this.quiet = quiet;
    }

    @Override
    public void overwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    @Override
    public void onlyIfNewer(boolean onlyIfNewer) {
        this.onlyIfNewer = onlyIfNewer;
        this.cache = 0L;
    }

    @Override
    public void compress(boolean compress) {
        this.compress = compress;
    }

    @Override
    public void username(String username) {
        this.username = username;
    }

    @Override
    public void password(String password) {
        this.password = password;
    }

    @Override
    public void headers(Map<String, String> headers) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, String>();
        } else {
            this.headers.clear();
        }
        if (headers != null) {
            this.headers.putAll(headers);
        }
    }

    @Override
    public void header(String name, String value) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, String>();
        }
        this.headers.put(name, value);
    }

    @Override
    public void acceptAnyCertificate(boolean accept) {
        this.acceptAnyCertificate = accept;
    }

    @Override
    public Object getSrc() {
        if (this.sources.size() == 1) {
            return this.sources.get(0);
        }
        return this.sources;
    }

    @Override
    public File getDest() {
        return this.dest;
    }

    @Override
    public boolean isQuiet() {
        return this.quiet;
    }

    @Override
    public boolean isOverwrite() {
        return this.overwrite;
    }

    @Override
    public boolean isOnlyIfNewer() {
        return this.onlyIfNewer;
    }

    @Override
    public boolean isCompress() {
        return this.compress;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String getHeader(String name) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(name);
    }

    @Override
    public boolean isAcceptAnyCertificate() {
        return this.acceptAnyCertificate;
    }

    private SSLConnectionSocketFactory getInsecureSSLSocketFactory() {
        if (this.insecureSSLSocketFactory == null) {
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, INSECURE_TRUST_MANAGERS, new SecureRandom());
                this.insecureSSLSocketFactory = new SSLConnectionSocketFactory(sc, INSECURE_HOSTNAME_VERIFIER);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (KeyManagementException e) {
                throw new RuntimeException(e);
            }
        }
        return this.insecureSSLSocketFactory;
    }

    @Override
    public void cache(long amount, TimeUnit unit) {
        this.cache = unit.toMillis(amount);
        this.onlyIfNewer = this.cache > 0L;
    }

    @Override
    public long getCache() {
        return this.cache;
    }

    @Override
    public void maxDownloadThreads(int maxDownloadThreads) {
        this.maxDownloadThreads = maxDownloadThreads;
    }

    @Override
    public int getMaxDownloadThreads() {
        return this.maxDownloadThreads;
    }

    private class Downloader
    implements Callable<Void> {
        private final CloseableHttpClient client;
        private final URL source;
        private final File dest;
        private ProgressLogger progressLogger;
        private AtomicLong total = new AtomicLong(0L);
        private AtomicLong current = new AtomicLong(0L);
        private volatile long lastProgressPublishing = 0L;

        Downloader(CloseableHttpClient client, URL source, File dest) {
            this.client = client;
            this.source = source;
            this.dest = dest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            Method newOperation;
            if (!DownloadAction.this.quiet) {
                try {
                    Method getServices = DownloadAction.this.project.getClass().getMethod("getServices", new Class[0]);
                    Object serviceFactory = getServices.invoke((Object)DownloadAction.this.project, new Object[0]);
                    Method get = serviceFactory.getClass().getMethod("get", Class.class);
                    Object progressLoggerFactory = get.invoke(serviceFactory, ProgressLoggerFactory.class);
                    newOperation = progressLoggerFactory.getClass().getMethod("newOperation", Class.class);
                    this.progressLogger = (ProgressLogger)newOperation.invoke(progressLoggerFactory, this.getClass());
                    String desc = "Download " + this.source.toString();
                    Method setDescription = this.progressLogger.getClass().getMethod("setDescription", String.class);
                    setDescription.setAccessible(true);
                    setDescription.invoke((Object)this.progressLogger, desc);
                    Method setLoggingHeader = this.progressLogger.getClass().getMethod("setLoggingHeader", String.class);
                    setLoggingHeader.setAccessible(true);
                    setLoggingHeader.invoke((Object)this.progressLogger, desc);
                }
                catch (Exception e) {
                    DownloadAction.this.project.getLogger().error("Unable to get progress logger. Download progress will not be displayed.");
                }
            }
            CloseableHttpResponse response = null;
            try {
                long timestamp = DownloadAction.this.onlyIfNewer && this.dest.exists() ? this.dest.lastModified() : 0L;
                HttpHost httpHost = new HttpHost(this.source.getHost(), this.source.getPort(), this.source.getProtocol());
                response = DownloadAction.this.openConnection(httpHost, this.source.getFile(), timestamp, this.client);
                if (response == null) {
                    newOperation = null;
                    return newOperation;
                }
                long lastModified = DownloadAction.this.parseLastModified((HttpResponse)response);
                int code = response.getStatusLine().getStatusCode();
                if (code == 304 || lastModified != 0L && timestamp >= lastModified) {
                    if (!DownloadAction.this.quiet) {
                        DownloadAction.this.project.getLogger().info("Not modified. Skipping '" + this.source + "'");
                    }
                    DownloadAction.this.upToDate.incrementAndGet();
                    Void void_ = null;
                    return void_;
                }
                this.performDownload((HttpResponse)response, this.dest);
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void performDownload(HttpResponse response, File destFile) throws IOException {
            File tmp = File.createTempFile(".downloader", destFile.getName(), destFile.getParentFile());
            tmp.deleteOnExit();
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                return;
            }
            long contentLength = entity.getContentLength();
            if (contentLength >= 0L) {
                this.total.addAndGet(contentLength);
            }
            FilterInputStream is = new BufferedInputStream(entity.getContent());
            if (DownloadAction.this.isContentCompressed(entity)) {
                is = new GZIPInputStream(is);
            }
            try {
                this.startProgress();
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tmp));
                try {
                    int read;
                    byte[] buf = new byte[10240];
                    while ((read = ((InputStream)is).read(buf)) >= 0) {
                        ((OutputStream)os).write(buf, 0, read);
                        this.current.addAndGet(read);
                        this.logProgress();
                    }
                    ((OutputStream)os).close();
                    if (destFile.exists() && !destFile.delete()) {
                        throw new GradleException("Unable to erase dest file " + destFile);
                    }
                    if (!tmp.renameTo(destFile)) {
                        throw new GradleException("Unable to move " + tmp + " to " + destFile);
                    }
                }
                finally {
                    ((OutputStream)os).close();
                    if (!tmp.delete()) {
                        DownloadAction.this.project.getLogger().warn("Unable to delete temporary file " + tmp);
                    }
                }
            }
            finally {
                ((InputStream)is).close();
                EntityUtils.consumeQuietly((HttpEntity)entity);
                this.completeProgress();
            }
            long newTimestamp = DownloadAction.this.parseLastModified(response);
            if (DownloadAction.this.onlyIfNewer && newTimestamp > 0L) {
                destFile.setLastModified(newTimestamp);
            }
        }

        private void startProgress() {
            if (this.progressLogger != null) {
                this.progressLogger.started();
            }
        }

        private void completeProgress() {
            if (this.progressLogger != null) {
                this.progressLogger.completed();
            }
        }

        private void logProgress() {
            if (this.progressLogger == null) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            long current = this.current.get();
            long total = this.total.get();
            if (current > 0L && currentTime - this.lastProgressPublishing > 1000L) {
                this.lastProgressPublishing = currentTime;
                StringBuilder builder = new StringBuilder();
                builder.append(DownloadAction.this.toLengthText(current));
                if (total > 0L) {
                    builder.append(" / ").append(DownloadAction.this.toLengthText(total));
                }
                builder.append(" downloaded");
                this.progressLogger.progress(builder.toString());
            }
        }
    }
}

