/*
 * Decompiled with CFR 0.152.
 */
package rw.bootstrap;

import java.io.InputStreamReader;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rw.bootstrap.ChainConfiguration;
import rw.bootstrap.RWApi;
import rw.bootstrap.RWConfiguration;

public class RWBootstrap {
    private static final Logger LOGGER = LoggerFactory.getLogger(RWBootstrap.class);
    private static final Map<Class<? extends RWApi<?>>, Class<? extends RWConfiguration<?, ?>>> API_MAPPINGS = new HashMap();
    private static final String IMPL_FORMAT = "META-INF/rwBootstrap/%s.properties";

    private RWBootstrap() throws IllegalAccessException {
        throw new IllegalAccessException("Cannot create instance of static helper class!");
    }

    public static <Api extends RWApi<Config>, Config extends RWConfiguration<Config, Api>> Api api(Class<? extends Api> apiClass) {
        return ((RWConfiguration)RWBootstrap.custom(apiClass)).build();
    }

    public static <Api extends RWApi<Config>, Config extends RWConfiguration<Config, Api>> Config custom(Class<? extends Api> apiClass) {
        if (!RWApi.class.isAssignableFrom(apiClass)) {
            LOGGER.error("{} cannot be casted to {}", apiClass, RWApi.class);
            throw new RuntimeException("Incorrect API class");
        }
        Class<Config> config = RWBootstrap.lookupImplementation(apiClass);
        try {
            return (Config)((RWConfiguration)config.newInstance());
        }
        catch (Exception e) {
            LOGGER.error("Error occurred during configuration creation", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <Api extends RWApi<Config>, Config extends RWConfiguration<Config, Api>> Class<? extends Config> lookupImplementation(Class<? extends Api> apiClass) {
        Class<RWConfiguration<?, ?>> implClass = API_MAPPINGS.get(apiClass);
        if (implClass == null) {
            Map<Class<? extends RWApi<?>>, Class<? extends RWConfiguration<?, ?>>> map = API_MAPPINGS;
            synchronized (map) {
                implClass = API_MAPPINGS.get(apiClass);
                if (implClass == null) {
                    implClass = RWBootstrap.findImplementation(apiClass);
                    if (implClass == null) {
                        throw new RuntimeException("Unable to find implementation for " + apiClass);
                    }
                    API_MAPPINGS.put(apiClass, implClass);
                }
            }
        }
        return implClass;
    }

    private static <Api extends RWApi<Config>, Config extends RWConfiguration<Config, Api>> Class<? extends RWConfiguration<?, ?>> findImplementation(Class<? extends Api> apiClass) {
        int modifiers = apiClass.getModifiers();
        boolean isInterface = Modifier.isInterface(modifiers);
        boolean isAbstract = Modifier.isAbstract(modifiers);
        LOGGER.debug("{} is {}interface and {}abstract class", new Object[]{apiClass, isInterface ? "" : "not ", isAbstract ? "" : "not "});
        if (!isAbstract && !isInterface) {
            LOGGER.debug("{} recognized as direct implementation");
            return RWBootstrap.getConfigurationChain(apiClass);
        }
        return RWBootstrap.recursiveLookup(RWBootstrap.class.getClassLoader(), apiClass);
    }

    private static <Api extends RWApi<Config>, Config extends RWConfiguration<Config, Api>> Class<? extends RWConfiguration<?, ?>> recursiveLookup(ClassLoader classLoader, Class<?> apiClass) {
        if (apiClass == null || !RWApi.class.isAssignableFrom(apiClass)) {
            return null;
        }
        LOGGER.debug("Trying to lookup implementation for {}", apiClass);
        try {
            List<URL> urls = RWBootstrap.toList(classLoader.getResources(String.format(IMPL_FORMAT, apiClass.getName())));
            if (urls.size() == 0) {
                return null;
            }
            LOGGER.debug("Found following implementations descriptors: {}", urls);
            if (urls.size() > 1) {
                LOGGER.warn("{} more than one implementations found, picking first in queue");
            }
            URL url = urls.get(0);
            Properties properties = new Properties();
            properties.load(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
            String implClassName = properties.getProperty("implementation-class");
            if (implClassName == null) {
                LOGGER.warn("Missing implementation-class property in descriptor {}", (Object)url);
                throw new RuntimeException("Missing implementation-class property in descriptor " + url);
            }
            Class<?> implClass = Class.forName(implClassName, true, classLoader);
            return RWBootstrap.getConfigurationChain(implClass);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred during implementation lookup", (Throwable)e);
            Class<RWConfiguration<?, ?>> config = RWBootstrap.recursiveLookup(classLoader, apiClass.getSuperclass());
            if (config != null) {
                return config;
            }
            for (Class<?> interfaceClass : apiClass.getInterfaces()) {
                config = RWBootstrap.recursiveLookup(classLoader, interfaceClass);
                if (config == null) continue;
                return config;
            }
            return null;
        }
    }

    private static <Api extends RWApi<Config>, Config extends RWConfiguration<Config, Api>> Class<? extends Config> getConfigurationChain(Class<?> apiClass) {
        ChainConfiguration config = apiClass.getAnnotation(ChainConfiguration.class);
        if (config == null) {
            LOGGER.error("Found implementation {} with missing ChainConfiguration annotation, fix it!", apiClass);
            throw new RuntimeException("Missing ChainConfiguration annotation for " + apiClass);
        }
        return config.value();
    }

    private static <T> List<T> toList(Enumeration<T> enumeration) {
        ArrayList<T> list = new ArrayList<T>();
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        return list;
    }
}

