package rw.bootstrap;

import java.util.HashMap;
import java.util.Map;

public abstract class RWConfiguration<Config extends RWConfiguration<Config, Api>, Api extends RWApi<Config>> {
    @SuppressWarnings("unchecked")
    private Config getSelfConfig() {
        return (Config) this;
    }

    private Map<String, Object> mExtraProperties;

    public Map<String, Object> getExtraProperties() {
        if (mExtraProperties == null) {
            synchronized (this) {
                if (mExtraProperties == null) {
                    mExtraProperties = new HashMap<>();
                }
            }
        }
        return mExtraProperties;
    }

    public boolean hasExtraProperties() {
        return mExtraProperties != null;
    }

    public Config extra(String key, Object value) {
        getExtraProperties().put(key, value);
        return getSelfConfig();
    }

    protected abstract Api create();

    public Api build() {
        Api api = create();
        api.init(getSelfConfig());
        return api;
    }
}
