/*
 * Decompiled with CFR 0.152.
 */
package pw.krejci.log4j2.tracedepth;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.util.PerformanceSensitive;

@Plugin(name="TraceDepthPatternConverter", category="Converter")
@ConverterKeys(value={"traceDepth"})
@PerformanceSensitive(value={"allocation"})
public final class TraceDepthPatternConverter
extends LogEventPatternConverter {
    private final ThreadLocal<Integer> traceDepth = ThreadLocal.withInitial(() -> 0);
    private final String indentStep;

    private TraceDepthPatternConverter(String[] options) {
        super("TraceDepth", "trace-depth");
        if (options == null || options.length != 1) {
            this.indentStep = "  ";
        } else {
            int length;
            try {
                length = Integer.parseInt(options[0]);
            }
            catch (NumberFormatException e) {
                this.indentStep = "  ";
                return;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                sb.append(' ');
            }
            this.indentStep = sb.toString();
        }
    }

    public static TraceDepthPatternConverter newInstance(String[] options) {
        return new TraceDepthPatternConverter(options);
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        if (event.getLevel() != Level.TRACE) {
            return;
        }
        int depth = this.traceDepth.get();
        if (event.getMarker() == AbstractLogger.EXIT_MARKER) {
            this.traceDepth.set(--depth);
        }
        for (int i = 0; i < depth; ++i) {
            toAppendTo.append(this.indentStep);
        }
        if (event.getMarker() == AbstractLogger.ENTRY_MARKER) {
            this.traceDepth.set(depth + 1);
        }
    }
}

