/*
 * Decompiled with CFR 0.152.
 */
package pw.krejci.mrc;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.jar.AbstractJarMojo;
import org.apache.maven.plugins.jar.JarMojo;
import org.apache.maven.shared.utils.io.FileUtils;
import pw.krejci.mrc.CompileMojo;
import pw.krejci.mrc.MultiReleaseJarSupport;

@Mojo(name="jar", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class MrJarMojo
extends JarMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true, required=true)
    private File buildOutputDirectory;
    @Parameter(defaultValue="${project.build.directory}/multi-release-jar", readonly=true, required=true)
    private File multiReleaseClasses;
    @Parameter(defaultValue="${basedir}/src/main/java-mr")
    private File multiReleaseSourcesDirectory;
    @Parameter
    private String mainModuleInfo;

    protected File getClassesDirectory() {
        if (MultiReleaseJarSupport.isAvailable()) {
            return this.multiReleaseClasses;
        }
        return super.getClassesDirectory();
    }

    public void execute() throws MojoExecutionException {
        if (!MultiReleaseJarSupport.isAvailable() || !this.multiReleaseSourcesDirectory.exists()) {
            if (!MultiReleaseJarSupport.isAvailable()) {
                this.getLog().info((CharSequence)"This java version does not support multi-release jars.");
            }
            super.execute();
            return;
        }
        if (!this.multiReleaseClasses.mkdirs()) {
            throw new MojoExecutionException("Failed to create the directory for multi-release-jar: " + this.multiReleaseClasses);
        }
        try {
            FileUtils.copyDirectoryStructure((File)this.buildOutputDirectory, (File)this.multiReleaseClasses);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy " + this.buildOutputDirectory + " to " + this.multiReleaseClasses + ".", (Exception)e);
        }
        if (this.mainModuleInfo != null) {
            File sourceModuleInfo = new File(CompileMojo.getOutputDirectory(this.buildOutputDirectory, this.mainModuleInfo), "module-info.class");
            File targetModuleInfo = new File(this.multiReleaseClasses, "module-info.class");
            try {
                Files.move(sourceModuleInfo.toPath(), targetModuleInfo.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to move module-info.class from " + sourceModuleInfo + " to " + targetModuleInfo, (Exception)e);
            }
        }
        boolean addMultiReleaseEntry = false;
        File[] sourceDirs = this.multiReleaseSourcesDirectory.listFiles(File::isDirectory);
        if (sourceDirs != null && sourceDirs.length > 0) {
            for (File mrBase : sourceDirs) {
                String release = mrBase.getName();
                File releaseOutput = CompileMojo.getOutputDirectory(this.buildOutputDirectory, release);
                String[] directChildren = releaseOutput.list();
                addMultiReleaseEntry = addMultiReleaseEntry || directChildren != null && directChildren.length > 0;
                try {
                    FileUtils.copyDirectoryStructure((File)releaseOutput, (File)new File(this.multiReleaseClasses, "META-INF/versions/" + release));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to copy " + releaseOutput + " to " + this.multiReleaseClasses + ".", (Exception)e);
                }
            }
            if (addMultiReleaseEntry) {
                this.addMultiReleaseManifestEntry();
            }
        }
        super.execute();
    }

    private void addMultiReleaseManifestEntry() throws MojoExecutionException {
        try {
            Field archive = AbstractJarMojo.class.getDeclaredField("archive");
            archive.setAccessible(true);
            MavenArchiveConfiguration config = (MavenArchiveConfiguration)archive.get((Object)this);
            config.addManifestEntry("Multi-Release", "true");
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new MojoExecutionException("Could not modify the archive configuration.", (Exception)e);
        }
    }
}

