/*
 * Decompiled with CFR 0.152.
 */
package pw.krejci.mrc;

import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.compiler.CompilationFailureException;
import org.apache.maven.plugin.compiler.CompilerMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import pw.krejci.mrc.CompileConfiguration;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class CompileMojo
extends CompilerMojo {
    @Parameter(defaultValue="${basedir}/src/main/java-mr")
    private File multiReleaseSourcesDirectory;
    @Parameter
    private List<CompileConfiguration> perReleaseConfiguration;
    @Parameter
    private Set<String> includes = new HashSet<String>();
    @Parameter
    private Set<String> excludes = new HashSet<String>();
    private CompileConfiguration currentConfiguration;
    private String currentSourceDirectory;
    private String defaultOutputDirectory;
    private String defaultSourceDirectory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, CompilationFailureException {
        if (!this.multiReleaseSourcesDirectory.exists()) {
            super.execute();
            return;
        }
        Map<Object, Object> configMap = this.perReleaseConfiguration == null || this.perReleaseConfiguration.isEmpty() ? Collections.emptyMap() : this.perReleaseConfiguration.stream().collect(Collectors.toMap(CompileConfiguration::getRelease, Function.identity()));
        this.defaultOutputDirectory = this.getProject().getBuild().getOutputDirectory();
        this.defaultSourceDirectory = this.getProject().getBuild().getSourceDirectory();
        super.execute();
        try {
            for (File mrBase : this.multiReleaseSourcesDirectory.listFiles(File::isDirectory)) {
                String release = mrBase.getName();
                this.currentConfiguration = configMap.containsKey(release) ? (CompileConfiguration)configMap.get(release) : CompileConfiguration.emptyForRelease(release);
                this.currentSourceDirectory = mrBase.getAbsolutePath();
                this.getProject().getBuild().setOutputDirectory(this.getOutputDirectory().toString());
                if (this.currentConfiguration.getConfiguration().getRelease() == null) {
                    this.currentConfiguration.getConfiguration().setRelease(release);
                }
                if (this.currentConfiguration.getConfiguration().getSource() == null) {
                    this.currentConfiguration.getConfiguration().setSource(release);
                }
                if (this.currentConfiguration.getConfiguration().getTarget() == null) {
                    this.currentConfiguration.getConfiguration().setTarget(release);
                }
                if (this.currentConfiguration.getConfiguration().getCompilerArgs() != null) {
                    this.compilerArgs = this.currentConfiguration.getConfiguration().getCompilerArgs();
                }
                if (this.currentConfiguration.getConfiguration().getRelease() != null) {
                    this.release = this.currentConfiguration.getConfiguration().getRelease();
                }
                super.execute();
            }
        }
        finally {
            this.getProject().getBuild().setOutputDirectory(this.defaultOutputDirectory);
        }
    }

    protected List<String> getCompileSourceRoots() {
        return super.getCompileSourceRoots().stream().map(e -> this.currentSourceDirectory != null && e.equals(this.defaultSourceDirectory) ? this.currentSourceDirectory : e).collect(Collectors.toList());
    }

    protected List<String> getClasspathElements() {
        String currentOutput = this.getProject().getBuild().getOutputDirectory();
        return super.getClasspathElements().stream().map(e -> this.defaultOutputDirectory != null && e.equals(currentOutput) ? this.defaultOutputDirectory : e).collect(Collectors.toList());
    }

    protected File getOutputDirectory() {
        if (this.currentConfiguration == null) {
            return super.getOutputDirectory();
        }
        return CompileMojo.getOutputDirectory(super.getOutputDirectory(), this.currentConfiguration.getRelease());
    }

    protected static File getOutputDirectory(File defaultOutputDirectory, String modifier) {
        Path p = defaultOutputDirectory.toPath();
        Path parent = p.getParent();
        Path fileName = p.getFileName();
        Path newPath = parent.resolve(fileName.toString() + "-" + modifier);
        return newPath.toFile();
    }

    protected SourceInclusionScanner getSourceInclusionScanner(int staleMillis) {
        StaleSourceScanner scanner;
        Set includes = this.getOrCall(CompileConfiguration.Configuration::getIncludes, () -> this.includes);
        Set excludes = this.getOrCall(CompileConfiguration.Configuration::getExcludes, () -> this.excludes);
        if (includes.isEmpty() && excludes.isEmpty()) {
            scanner = new StaleSourceScanner((long)staleMillis);
        } else {
            if (includes.isEmpty()) {
                includes.add("**/*.java");
            }
            scanner = new StaleSourceScanner((long)staleMillis, includes, excludes);
        }
        return scanner;
    }

    protected SourceInclusionScanner getSourceInclusionScanner(String inputFileEnding) {
        SimpleSourceInclusionScanner scanner;
        Set<String> includes = this.getOrCall(CompileConfiguration.Configuration::getIncludes, () -> this.includes);
        Set excludes = this.getOrCall(CompileConfiguration.Configuration::getExcludes, () -> this.excludes);
        String defaultIncludePattern = "**/*" + (inputFileEnding.startsWith(".") ? "" : ".") + inputFileEnding;
        if (includes.isEmpty() && excludes.isEmpty()) {
            includes = Collections.singleton(defaultIncludePattern);
            scanner = new SimpleSourceInclusionScanner(includes, Collections.emptySet());
        } else {
            if (includes.isEmpty()) {
                includes.add(defaultIncludePattern);
            }
            scanner = new SimpleSourceInclusionScanner(includes, excludes);
        }
        return scanner;
    }

    protected String getSource() {
        return this.getOrCall(CompileConfiguration.Configuration::getSource, () -> super.getSource());
    }

    protected String getTarget() {
        return this.getOrCall(CompileConfiguration.Configuration::getTarget, () -> super.getTarget());
    }

    protected String getRelease() {
        return this.getOrCall(CompileConfiguration.Configuration::getRelease, () -> super.getRelease());
    }

    protected String getCompilerArgument() {
        return this.getOrCall(CompileConfiguration.Configuration::getCompilerArgument, () -> super.getCompilerArgument());
    }

    protected Map<String, String> getCompilerArguments() {
        return this.getOrCall(CompileConfiguration.Configuration::getCompilerArguments, () -> super.getCompilerArguments());
    }

    protected File getGeneratedSourcesDirectory() {
        return this.getOrCall(CompileConfiguration.Configuration::getGeneratedSourcesDirectory, () -> super.getGeneratedSourcesDirectory());
    }

    private <T> T getOrCall(Function<CompileConfiguration.Configuration, T> configOption, Supplier<T> call) {
        T val;
        if (this.currentConfiguration != null && (val = configOption.apply(this.currentConfiguration.getConfiguration())) != null) {
            return val;
        }
        return call.get();
    }
}

