/*
 * Decompiled with CFR 0.152.
 */
package pw.krejci.mrc;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.utils.io.FileUtils;
import pw.krejci.mrc.CompileMojo;

@Mojo(name="jar", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class JarMojo
extends org.apache.maven.plugins.jar.JarMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true, required=true)
    private File buildOutputDirectory;
    @Parameter(defaultValue="${project.build.directory}/multi-release-jar", readonly=true, required=true)
    private File multiReleaseClasses;
    @Parameter(defaultValue="${basedir}/src/main/java-mr")
    private File multiReleaseSourcesDirectory;
    @Parameter
    private String mainModuleInfo;

    protected File getClassesDirectory() {
        return this.multiReleaseClasses;
    }

    public void execute() throws MojoExecutionException {
        if (!this.multiReleaseSourcesDirectory.exists()) {
            super.execute();
            return;
        }
        if (!this.multiReleaseClasses.mkdirs()) {
            throw new MojoExecutionException("Failed to create the directory for multi-release-jar: " + this.multiReleaseClasses);
        }
        try {
            FileUtils.copyDirectoryStructure((File)this.buildOutputDirectory, (File)this.multiReleaseClasses);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy " + this.buildOutputDirectory + " to " + this.multiReleaseClasses + ".", (Exception)e);
        }
        if (this.mainModuleInfo != null) {
            File sourceModuleInfo = new File(CompileMojo.getOutputDirectory(this.buildOutputDirectory, this.mainModuleInfo), "module-info.class");
            File targetModuleInfo = new File(this.multiReleaseClasses, "module-info.class");
            try {
                Files.move(sourceModuleInfo.toPath(), targetModuleInfo.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to move module-info.class from " + sourceModuleInfo + " to " + targetModuleInfo, (Exception)e);
            }
        }
        for (File mrBase : this.multiReleaseSourcesDirectory.listFiles(File::isDirectory)) {
            String release = mrBase.getName();
            File releaseOutput = CompileMojo.getOutputDirectory(this.buildOutputDirectory, release);
            try {
                FileUtils.copyDirectoryStructure((File)releaseOutput, (File)new File(this.multiReleaseClasses, "META-INF/versions/" + release));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy " + releaseOutput + " to " + this.multiReleaseClasses + ".", (Exception)e);
            }
        }
        super.execute();
    }
}

