/*
 * Decompiled with CFR 0.152.
 */
package pw.krejci.modules.maven;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.ModuleFinder;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.PathUtils;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.jboss.modules.Version;
import pw.krejci.modules.maven.ImportEverythingExportServices;
import pw.krejci.modules.maven.MavenBootstrap;
import pw.krejci.modules.maven.ModuleSpecController;

public class MavenModuleFinder
implements ModuleFinder {
    private final RepositorySystemSession mavenSession;
    private final RepositorySystem repositorySystem = MavenBootstrap.newRepositorySystem();
    private final List<RemoteRepository> remoteRepos;
    private final ModuleSpecController modifier;

    public MavenModuleFinder() {
        this(new File(new File(System.getProperty("user.home"), ".m2"), "repository"));
    }

    public MavenModuleFinder(File localMavenRepo) {
        this(localMavenRepo, MavenModuleFinder.mavenCentral(), ModuleSpecController.NOOP);
    }

    public MavenModuleFinder(File localMavenRepo, Map<String, URI> remoteRepos, ModuleSpecController modifier) {
        this.mavenSession = MavenBootstrap.newRepositorySystemSession(this.repositorySystem, localMavenRepo);
        this.modifier = modifier;
        this.remoteRepos = remoteRepos.entrySet().stream().map(e -> new RemoteRepository.Builder((String)e.getKey(), "default", ((URI)e.getValue()).toString()).build()).collect(Collectors.toList());
    }

    private static Map<String, URI> mavenCentral() {
        HashMap<String, URI> ret = new HashMap<String, URI>(1);
        ret.put("central", URI.create("https://repo.maven.apache.org/maven2/"));
        return ret;
    }

    public ModuleSpec findModule(String name, ModuleLoader delegateLoader) throws ModuleLoadException {
        try {
            DefaultArtifact check = new DefaultArtifact(name);
            if (!check.toString().equals(name)) {
                throw new ModuleLoadException("Non-canonical Maven coordinates used as module name. '" + name + "' should rather be '" + check.toString() + "'.");
            }
            Artifact artifact = this.resolveArtifact((Artifact)new DefaultArtifact(name));
            this.modifier.start(name);
            ModuleSpec.Builder bld = ModuleSpec.build((String)name);
            bld.setVersion(Version.parse((String)artifact.getVersion()));
            bld.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)ResourceLoaders.createJarResourceLoader((String)name, (JarFile)new JarFile(artifact.getFile()))));
            bld.addDependency(DependencySpec.createLocalDependencySpec());
            bld.addDependency(DependencySpec.createSystemDependencySpec((Set)PathUtils.getPathSet(null)));
            this.resolveDependencies(artifact).stream().filter(a -> !artifact.toString().equals(a.toString()) && "jar".equalsIgnoreCase(a.getExtension())).map(a -> {
                String depName = a.toString();
                return this.modifier.modifyDependency(depName, ImportEverythingExportServices.spec(depName));
            }).filter(Objects::nonNull).forEach(arg_0 -> ((ModuleSpec.Builder)bld).addDependency(arg_0));
            this.modifier.modify(bld);
            this.modifier.end(name);
            return bld.create();
        }
        catch (IOException | IllegalStateException | ArtifactResolutionException e) {
            throw new ModuleLoadException(e);
        }
    }

    private Artifact resolveArtifact(Artifact artifact) throws ArtifactResolutionException {
        ArtifactRequest request = new ArtifactRequest();
        request.setRepositories(this.remoteRepos);
        request.setArtifact(artifact);
        ArtifactResult result = this.repositorySystem.resolveArtifact(this.mavenSession, request);
        if (!result.isResolved() || result.isMissing()) {
            throw new IllegalStateException("Failed to resolve the artifact " + artifact);
        }
        return result.getArtifact();
    }

    private Collection<Artifact> resolveDependencies(Artifact artifact) {
        DependencyResult result;
        CollectRequest collectRequest = new CollectRequest(new Dependency(artifact, null), this.remoteRepos);
        DependencyRequest request = new DependencyRequest(collectRequest, null);
        try {
            result = this.repositorySystem.resolveDependencies(this.mavenSession, request);
        }
        catch (DependencyResolutionException dre) {
            result = dre.getResult();
        }
        if (result == null) {
            return Collections.emptyList();
        }
        return result.getArtifactResults().stream().map(ArtifactResult::getArtifact).collect(Collectors.toSet());
    }
}

