/*
 * Decompiled with CFR 0.152.
 */
package pw.krejci.jmh.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.compiler.CompilationFailureException;
import org.apache.maven.plugin.compiler.TestCompilerMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.repository.RepositorySystem;

@Mojo(name="benchmark", requiresDirectInvocation=true, requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.PROCESS_TEST_RESOURCES)
public class BenchmarkMojo
extends TestCompilerMojo {
    private static final String PROPERTY_PREFIX = "jmh.";
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession benchmarkSession;
    @Parameter(property="jmh.bm")
    private String benchmarkMode;
    @Parameter(property="jmh.bs")
    private Integer batchSize;
    @Parameter(property="jmh.e")
    private List<String> exclude;
    @Parameter(property="jmh.f")
    private Integer fork;
    @Parameter(property="jmh.foe")
    private Boolean failOnError;
    @Parameter(property="jmh.gc")
    private Boolean forceGC;
    @Parameter(property="jmh.h")
    private boolean help;
    @Parameter(property="jmh.i")
    private Integer iterations;
    @Parameter(property="jmh.lprof")
    private boolean listProfilers;
    @Parameter(property="jmh.o")
    private File outputFile;
    @Parameter(property="jmh.opi")
    private Integer operationsPerInvocation;
    @Parameter(property="jmh.prof")
    private String profiler;
    @Parameter(property="jmh.r")
    private String timeOnIteration;
    @Parameter(property="jmh.rf")
    private String resultFormat;
    @Parameter(property="jmh.rff")
    private String resultsFile;
    @Parameter(property="jmh.si")
    private Boolean synchronizeIterations;
    @Parameter(property="jmh.t")
    private Integer threads;
    @Parameter(property="jmh.tg")
    private List<Integer> threadGroups;
    @Parameter(property="jmh.to")
    private String timeout;
    @Parameter(property="jmh.tu")
    private String timeUnit;
    @Parameter(property="jmh.v")
    private String verbosity;
    @Parameter(property="jmh.w")
    private String warmup;
    @Parameter(property="jmh.wbs")
    private Integer warmupBatchSize;
    @Parameter(property="jmh.wf")
    private Integer warmupForks;
    @Parameter(property="jmh.wi")
    private Integer warmupIterations;
    @Parameter(property="jmh.wm")
    private String warmupMode;
    @Parameter(property="jmh.wmb")
    private List<String> warmupBenchmarks;
    @Parameter(property="jmh.benchmarks")
    private List<String> benchmarks;
    @Component
    private RepositorySystem benchmarkRepositorySystem;
    @Component
    private ArtifactHandlerManager benchmarkArtifactHandlerManager;
    @Component
    private ResolutionErrorHandler benchmarkResolutionErrorHandler;
    private List<String> jmhProcessorClasspathElements;

    public void execute() throws MojoExecutionException, CompilationFailureException {
        File outputDir = new File(this.getProject().getBuild().getOutputDirectory());
        if (!outputDir.exists()) {
            this.getLog().info((CharSequence)"No classes to build the benchmark for.");
            return;
        }
        super.execute();
        File benchmarkList = new File(new File(this.getProject().getBuild().getTestOutputDirectory(), "META-INF"), "BenchmarkList");
        if (!benchmarkList.exists()) {
            this.getLog().info((CharSequence)"No benchmarks found, skipping.");
            return;
        }
        this.runBenchMarks();
    }

    protected List<String> getClasspathElements() {
        this.ensureJmhProcessorResolved();
        List ret = super.getClasspathElements();
        ret.addAll(this.jmhProcessorClasspathElements);
        return ret;
    }

    private void ensureJmhProcessorResolved() {
        if (this.jmhProcessorClasspathElements != null) {
            return;
        }
        String jmhVersion = this.getProject().getDependencies().stream().filter(d -> d.getGroupId().equals("org.openjdk.jmh") && d.getArtifactId().equals("jmh-core")).map(Dependency::getVersion).findFirst().orElseThrow(() -> new IllegalStateException("Could not find jmh-core in the list of dependencies."));
        DefaultArtifact artifact = new DefaultArtifact("org.openjdk.jmh", "jmh-generator-annprocess", VersionRange.createFromVersion((String)jmhVersion), "runtime", "jar", null, this.benchmarkArtifactHandlerManager.getArtifactHandler("jar"), false);
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact((Artifact)artifact).setResolveRoot(true).setResolveTransitively(true).setLocalRepository(this.benchmarkSession.getLocalRepository()).setRemoteRepositories(this.getProject().getRemoteArtifactRepositories());
        ArtifactResolutionResult resolutionResult = this.benchmarkRepositorySystem.resolve(request);
        try {
            this.benchmarkResolutionErrorHandler.throwErrors(request, resolutionResult);
        }
        catch (ArtifactResolutionException e) {
            this.getLog().error((CharSequence)e.getMessage());
            throw new IllegalStateException("Failed to resolve the JMH annotation processor.");
        }
        ArrayList<String> elements = new ArrayList<String>(resolutionResult.getArtifacts().size());
        List classpathElements = super.getClasspathElements();
        for (Artifact resolved : resolutionResult.getArtifacts()) {
            String path = resolved.getFile().getAbsolutePath();
            if (classpathElements.contains(path)) continue;
            elements.add(path);
        }
        this.jmhProcessorClasspathElements = elements;
    }

    private void runBenchMarks() throws MojoExecutionException {
        List classPath = super.getClasspathElements();
        try {
            classPath.addAll(this.getProject().getTestClasspathElements());
        }
        catch (DependencyResolutionRequiredException dependencyResolutionRequiredException) {
            // empty catch block
        }
        String jvm = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        ArrayList<String> command = new ArrayList<String>();
        command.add(jvm);
        command.add("-cp");
        command.add(String.join((CharSequence)File.pathSeparator, classPath));
        command.add("org.openjdk.jmh.Main");
        if (this.help) {
            command.add("-h");
        }
        if (this.listProfilers) {
            command.add("-lprof");
        }
        BenchmarkMojo.addParameter(command, "-bm", this.benchmarkMode);
        BenchmarkMojo.addParameter(command, "-bs", this.batchSize);
        BenchmarkMojo.addParameter(command, "-e", this.exclude);
        BenchmarkMojo.addParameter(command, "-f", this.fork);
        BenchmarkMojo.addParameter(command, "-foe", this.failOnError);
        BenchmarkMojo.addParameter(command, "-gc", this.forceGC);
        BenchmarkMojo.addParameter(command, "-i", this.iterations);
        BenchmarkMojo.addParameter(command, "-o", this.outputFile);
        BenchmarkMojo.addParameter(command, "-opi", this.operationsPerInvocation);
        BenchmarkMojo.addParameter(command, "-prof", this.profiler);
        BenchmarkMojo.addParameter(command, "-r", this.timeOnIteration);
        BenchmarkMojo.addParameter(command, "-rf", this.resultFormat);
        BenchmarkMojo.addParameter(command, "-rff", this.resultsFile);
        BenchmarkMojo.addParameter(command, "-si", this.synchronizeIterations);
        BenchmarkMojo.addParameter(command, "-t", this.threads);
        BenchmarkMojo.addParameter(command, "-tg", this.threadGroups);
        BenchmarkMojo.addParameter(command, "-to", this.timeout);
        BenchmarkMojo.addParameter(command, "-tu", this.timeUnit);
        BenchmarkMojo.addParameter(command, "-v", this.verbosity);
        BenchmarkMojo.addParameter(command, "-w", this.warmup);
        BenchmarkMojo.addParameter(command, "-wbs", this.warmupBatchSize);
        BenchmarkMojo.addParameter(command, "-wf", this.warmupForks);
        BenchmarkMojo.addParameter(command, "-wi", this.warmupIterations);
        BenchmarkMojo.addParameter(command, "-wm", this.warmupMode);
        BenchmarkMojo.addParameter(command, "-wmb", this.warmupBenchmarks);
        if (this.benchmarks != null) {
            command.addAll(this.benchmarks);
        }
        this.getLog().debug((CharSequence)("Running JMH using: " + command));
        ProcessBuilder bld = new ProcessBuilder(command);
        bld.directory(this.getProject().getBasedir());
        bld.redirectErrorStream(true);
        try {
            this.getLog().info((CharSequence)"Executing the JMH benchmarks");
            Process process = bld.start();
            try (BufferedReader rdr = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = rdr.readLine()) != null) {
                    System.out.println(line);
                }
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new MojoExecutionException("The benchmark process failed with non-zero exit code: " + exitCode);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("Could not complete the benchmark: " + e.getMessage());
        }
    }

    private static void addParameter(List<String> command, String paramName, Object paramValue) {
        if ((paramValue = BenchmarkMojo.cleanseValue(paramValue)) != null) {
            if (paramValue instanceof List) {
                String val = ((List)paramValue).stream().map(BenchmarkMojo::cleanseValue).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(","));
                if (!val.isEmpty()) {
                    command.add(paramName);
                    command.add(val);
                }
            } else {
                command.add(paramName);
                command.add(paramValue.toString());
            }
        }
    }

    private static Object cleanseValue(Object paramValue) {
        if (paramValue == null) {
            return null;
        }
        if (paramValue instanceof String && ((String)paramValue).trim().isEmpty()) {
            return null;
        }
        return paramValue;
    }
}

