package pw.ian.sangria_scalapb

import scalapb.descriptors._
import com.trueaccord.scalapb._

case class FieldContext(
  desc: Descriptor,
  pmessage: PMessage,
  transformer: SchemaTransformer,
) {

  def transform(
    nextDesc: Descriptor,
    nextMsg: PMessage,
  ): FieldContext = {
    transformer.contextTransforms.get(desc.fullName) match {
      case Some(tfs) => {
        // TODO find out how to get the monoid A => A
        tfs.reduce((acc, el) => x => acc(el(x)))(this)
      }
      case None => this
    }
  }

  def transform(
    nextFieldDesc: FieldDescriptor,
    nextMsg: PMessage,
  ): FieldContext = {
    val nextDesc = nextFieldDesc.scalaType match {
      case ScalaType.Message(d) => d
      case _ => {
        throw new IllegalArgumentException(s"Field descriptor is not a message: ${nextFieldDesc.fullName}")
      }
    }
    transform(nextDesc, nextMsg)
  }


  def transform[T <: GeneratedMessage with Message[T]](msg: T)(
    implicit comp: GeneratedMessageCompanion[T],
  ): FieldContext = {
    transform(
      nextDesc = comp.scalaDescriptor,
      nextMsg = msg.toPMessage,
    )
  }

}
