/*
 * Decompiled with CFR 0.152.
 */
package pw.hysteria.input.dashfoo.command.parsing.impl;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import pw.hysteria.input.dashfoo.command.parsing.CommandRegexProvider;
import pw.hysteria.input.dashfoo.command.parsing.CommandSanityChecker;
import pw.hysteria.input.dashfoo.command.parsing.UserInputFlagParser;

public class RegexSmartParser
implements UserInputFlagParser {
    private final CommandRegexProvider regexProvider;
    private final CommandSanityChecker sanityChecker;

    public RegexSmartParser(CommandRegexProvider regexProvider, CommandSanityChecker sanityChecker) {
        this.regexProvider = regexProvider;
        this.sanityChecker = sanityChecker;
    }

    @Override
    public Map<String, String[]> mapUserInput(String toParse) {
        HashMap<String, String[]> results = new HashMap<String, String[]>();
        AbstractMap.SimpleEntry workingEntry = new AbstractMap.SimpleEntry("@default", new ArrayList());
        Matcher exploder = this.regexProvider.getExplosionPattern().matcher(toParse);
        boolean foundHandle = false;
        while (exploder.find()) {
            String element = this.regexProvider.postProcessString(exploder.group());
            if (this.regexProvider.isCommand(element) && !foundHandle) {
                foundHandle = true;
                continue;
            }
            if (this.regexProvider.isFlag(element)) {
                String flagName = workingEntry.getKey();
                String[] compiledArgs = workingEntry.getValue().toArray(new String[this.sanityChecker.getArity(flagName)]);
                results.put(flagName, compiledArgs);
                String newFlagName = this.regexProvider.getFlag(element);
                workingEntry = new AbstractMap.SimpleEntry(newFlagName, new ArrayList());
                continue;
            }
            workingEntry.getValue().add(element);
        }
        String flagName = workingEntry.getKey();
        String[] compiledArgs = workingEntry.getValue().toArray(new String[this.sanityChecker.getArity(flagName)]);
        results.put(flagName, compiledArgs);
        for (Map.Entry entryCheck : results.entrySet()) {
            if (this.sanityChecker.flagIsSane((String)entryCheck.getKey(), ((String[])entryCheck.getValue()).length)) continue;
            throw new IllegalArgumentException((String)entryCheck.getKey() + " failed sanity checks");
        }
        return results;
    }
}

