/*
 * Decompiled with CFR 0.152.
 */
package pw.hysteria.input.dashfoo.command.impl;

import java.util.Map;
import pw.hysteria.input.dashfoo.api.Initializes;
import pw.hysteria.input.dashfoo.command.Command;
import pw.hysteria.input.dashfoo.command.Flag;
import pw.hysteria.input.dashfoo.command.FlagDispatcher;
import pw.hysteria.input.dashfoo.command.HelpProvider;
import pw.hysteria.input.dashfoo.command.NullHelpProvider;
import pw.hysteria.input.dashfoo.command.parsing.UserInputFlagParser;

public abstract class FlaggedCommand
extends Command {
    private final FlagDispatcher flagDispatcher;
    private HelpProvider helpContract = NullHelpProvider.PROVIDER;

    public FlaggedCommand(FlagDispatcher dispatcher) {
        this.flagDispatcher = dispatcher;
    }

    @Override
    public final void invokeCommand(String commandText) throws Command.CommandException {
        Map<String, String[]> mappedInput = this.getFlagParser().mapUserInput(commandText);
        try {
            this.flagDispatcher.dispatch(mappedInput);
        }
        catch (Flag.FlagException fExcept) {
            throw new Command.CommandInvocationException("An exception was caught whilst executing the Flag: " + fExcept.getMessage());
        }
    }

    @Override
    public final void initialize() throws Initializes.InitializationException {
        this.initCommand();
    }

    @Override
    public final HelpProvider getHelpProvider() {
        return this.helpContract;
    }

    protected final FlagDispatcher getFlagDispatcher() {
        return this.flagDispatcher;
    }

    protected final void setHelpProvider(HelpProvider contract) {
        this.helpContract = contract;
    }

    protected abstract void initCommand() throws Initializes.InitializationException;

    protected abstract UserInputFlagParser getFlagParser();
}

