/*
 * Decompiled with CFR 0.152.
 */
package pw.hysteria.input.dashfoo.command;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pw.hysteria.input.dashfoo.command.Flag;
import pw.hysteria.input.dashfoo.command.HelpProvider;
import pw.hysteria.input.dashfoo.command.IsFlag;
import pw.hysteria.input.dashfoo.command.ParamTypeTransform;
import pw.hysteria.input.dashfoo.command.parametertransforms.ArrayTransformWrapper;
import pw.hysteria.input.dashfoo.command.parametertransforms.BooleanTransform;
import pw.hysteria.input.dashfoo.command.parametertransforms.ByteTransform;
import pw.hysteria.input.dashfoo.command.parametertransforms.DoubleTransform;
import pw.hysteria.input.dashfoo.command.parametertransforms.FloatTransform;
import pw.hysteria.input.dashfoo.command.parametertransforms.IntegerTransform;
import pw.hysteria.input.dashfoo.command.parametertransforms.LongTransform;
import pw.hysteria.input.dashfoo.command.parametertransforms.ShortTransform;
import pw.hysteria.input.dashfoo.command.parametertransforms.StringTransform;

public final class MethodAsInvokableFactory {
    private final Map<Class<?>, ParamTypeTransform<?>> transformMap = new HashMap();

    public MethodAsInvokableFactory() {
        this.registerTransform(String.class, new StringTransform());
        this.registerTransform(Boolean.class, new BooleanTransform());
        this.registerTransform(Byte.class, new ByteTransform());
        this.registerTransform(Short.class, new ShortTransform());
        this.registerTransform(Integer.class, new IntegerTransform());
        this.registerTransform(Long.class, new LongTransform());
        this.registerTransform(Float.class, new FloatTransform());
        this.registerTransform(Double.class, new DoubleTransform());
        this.registerTransform(Boolean.TYPE, new BooleanTransform());
        this.registerTransform(Byte.TYPE, new ByteTransform());
        this.registerTransform(Short.TYPE, new ShortTransform());
        this.registerTransform(Integer.TYPE, new IntegerTransform());
        this.registerTransform(Long.TYPE, new LongTransform());
        this.registerTransform(Float.TYPE, new FloatTransform());
        this.registerTransform(Double.TYPE, new DoubleTransform());
        this.registerTransform(String[].class, new ArrayTransformWrapper<String>(new StringTransform()));
        this.registerTransform(Boolean[].class, new ArrayTransformWrapper<Boolean>(new BooleanTransform()));
        this.registerTransform(Byte[].class, new ArrayTransformWrapper<Byte>(new ByteTransform()));
        this.registerTransform(Short[].class, new ArrayTransformWrapper<Short>(new ShortTransform()));
        this.registerTransform(Integer[].class, new ArrayTransformWrapper<Integer>(new IntegerTransform()));
        this.registerTransform(Long[].class, new ArrayTransformWrapper<Long>(new LongTransform()));
        this.registerTransform(Float[].class, new ArrayTransformWrapper<Float>(new FloatTransform()));
        this.registerTransform(Double[].class, new ArrayTransformWrapper<Double>(new DoubleTransform()));
    }

    public final <PT> void registerTransform(Class<PT> ptClass, ParamTypeTransform<PT> ptFactory) {
        if (this.transformMap.containsKey(ptClass)) {
            throw new IllegalArgumentException(ptClass.getName() + " already has a transform registered. Please unregister it first.");
        }
        this.transformMap.put(ptClass, ptFactory);
    }

    public void unregisterTransform(Class<?> ptClass) {
        if (!this.transformMap.containsKey(ptClass)) {
            throw new IllegalArgumentException(ptClass.getName() + " is not registered to a transform. Please register it first.");
        }
        this.transformMap.remove(ptClass);
    }

    public <PT> ParamTypeTransform<PT> translateParamToTransform(Class<PT> paramClass) {
        if (!this.transformMap.containsKey(paramClass)) {
            throw new IllegalArgumentException("No such parameter mapping exists");
        }
        return this.transformMap.get(paramClass);
    }

    private MethodAsFlag constructFromMethod(String[] handles, Method method, Object methodOwner) {
        if (methodOwner == null) {
            throw new IllegalArgumentException("Method owner is null");
        }
        ArrayList transforms = new ArrayList();
        for (Class<?> paramType : method.getParameterTypes()) {
            try {
                transforms.add(this.translateParamToTransform(paramType));
            }
            catch (IllegalArgumentException exception) {
                throw new IllegalStateException("Provided method contains unrecognized parameter types");
            }
        }
        return new MethodAsFlag(handles, transforms, method, methodOwner);
    }

    public MethodAsFlag constructFromMethod(Method method, Object methodOwner) {
        if (!method.isAnnotationPresent(IsFlag.class)) {
            throw new IllegalArgumentException("Provided method is not annotated with @IsFlag");
        }
        return this.constructFromMethod(method.getAnnotation(IsFlag.class).handles(), method, methodOwner);
    }

    public ArrayList<MethodAsFlag> constructFromClass(Object methodsOwner) {
        ArrayList<MethodAsFlag> compiledMethods = new ArrayList<MethodAsFlag>();
        for (Method method : methodsOwner.getClass().getMethods()) {
            if (!method.isAnnotationPresent(IsFlag.class)) continue;
            compiledMethods.add(this.constructFromMethod(method, methodsOwner));
        }
        return compiledMethods;
    }

    public static final class MethodAsFlag
    implements Flag,
    HelpProvider {
        private final List<ParamTypeTransform<?>> paramTypeTransforms;
        private final Method invokeMethod;
        private final Object invokeAgainst;
        private final String[] handles;

        MethodAsFlag(String[] acceptableFlags, List<ParamTypeTransform<?>> typeTransforms, Method methodToInvoke, Object methodContainerInstance) {
            this.handles = acceptableFlags;
            this.paramTypeTransforms = typeTransforms;
            this.invokeMethod = methodToInvoke;
            this.invokeAgainst = methodContainerInstance;
        }

        @Override
        public String[] getHandles() {
            return this.handles;
        }

        @Override
        public void invokeFlag(String ... args) throws Flag.FlagInvocationException {
            if (args.length > this.paramTypeTransforms.size()) {
                throw new Flag.FlagInvocationException("Number of arguments passed exceeds number of expected arguments", this, args);
            }
            Object[] methodArgs = new Object[args.length];
            int positionInParams = 0;
            for (String arg : args) {
                methodArgs[positionInParams] = this.paramTypeTransforms.get(positionInParams).transform(arg);
                ++positionInParams;
            }
            this.invokeMethod.setAccessible(true);
            try {
                Object methodReturn = this.invokeMethod.invoke(this.invokeAgainst, methodArgs);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Unable to access invocation target from current scope");
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Passed an invalid method container during construction");
            }
        }

        @Override
        public int getArity() {
            return this.paramTypeTransforms.size();
        }

        @Override
        public final HelpProvider getHelpProvider() {
            return this;
        }

        @Override
        public final String getDescription() {
            return null;
        }

        @Override
        public final String getHelp() {
            return null;
        }
    }
}

