/*
 * HYSTERIA GROUP LICENSE SPECIFICATION (1.2)
 * ================================================
 * An open-source-esque license that seeks to preserve some basic author rights whilst maintaining the integrity of an open-source project
 *
 * This license may also be applied to non-code works such as:
 * - Books
 * - Art
 * - Blueprints
 * - Movies
 *
 *
 * 1.1. Definitions
 *
 *     - THAT OF: Free
 *       - having no expressed cost
 *
 *     - THAT OF: Licensed
 *       - Any work that is expressed to be under this license
 *
 *     - THAT OF: Copyright
 *       - The right of someone to redistribute derivatives (or otherwise) of an original
 *
 *     - THAT OF: Intellectual Property
 *       - 1. The work of an individual, and the sole work thereof
 *       - 2. The work of a group of individuals, and the sole work thereof
 *
 * 1.2. Code Disclaimer(s)
 *
 *     1 ANY LICENSED code is provided as is
 *       .1 It is due to this that SHOULD any code within the LICENSED projects be in ANY way responsible for damages to a machine, or person(s) the AUTHOR is in no way responsible
 *       .2 This SHOULD NOT be NEGATED by an AUTHOR who has PUBLISHED under this LICENSE
 *
 * 1.3. License Restrictions
 *
 *     1. IN REGARDS TO: Licensing of derivatives and/or uses of the LICENSED work(s)
 *        .1 ANY derivative works MUST share the HGLSv*
 *        .2 ANY works that MAKE USE of the LICENSED work(s) must be published under the HGLSv*, a similar license, or a beerware-style license (so long as it preserves the HGLSv* values)
 *
 *     2. IN REGARDS TO: Cost
 *       .1 ALL derivative works MUST be free - no fees may be charged, unless you receive EXPRESSED PERMISSION from the AUTHOR
 *       .2 ANY works that MAKE USE of the LICENSED work(s) must also be FREE - no fees may be charged.
 *
 *     3. IN REGARDS TO: Intellectual property
 *        .N THIS license seeks to preserve the intellectual property of AUTHORS, whilst allowing such property to be freely re-used and distributed.
 *           IN ORDER to accomplish this, all USES AND DERIVATIVES must meet the following conditions
 *
 *       1. CREDIT FOR the work of ANY one AUTHOR must be preserved.
 *         .1 IF NO AUTHOR is specified DO NOT TAKE CREDIT. THIS is PUBLIC DOMAIN, and should REMAIN THAT WAY.
 *         .2 IF an AUTHOR is SPECIFIED, DO NOT CHANGE THE SPECIFIED AUTHOR's name UNDER ANY CONDITIONS
 *
 *       2. IF ADDING WORK of OTHER AUTHORS
 *          .1 INSURE that you are PERMITTED to DO SO
 *
 *       3. WHEN ADDING YOUR own WORK to a GROUP WORK
 *         .1 INSURE that YOU TAKE CREDIT for it
 *           .1 OTHERWISE, you are subject to section 1.3. , sub-section 3. , clause .1
 *         .2 SHOULD you be contributing to a LICENSED group work THAT
 *           .1 THE WORK shall remain under the HGLSv* LICENSE applied TO the GROUP WORK
 *           .2 IT IS THE DISCRETION of the PROJECT MANAGER whether or not YOUR WORK may be RELEASED from the LICENSE upon YOUR SOLE REQUEST
 *           .3 THE WORK shall BE IN YOUR NAME
 *              .1 SHOULD THE WORK be attributed to another FOR ANY REASON - that it is STILL YOUR WORK
 *                 .1 HOWEVER - YOU MUST speak with the PROJECT MANAGER in regards to the aforementioned MODIFICATION
 *
 *       4. AS AN AUTHOR (Author Rights)
 *          .1 YOU MAY
 *             .1 PUBLISH YOUR WORK under ANOTHER LICENSE, PURSUANT TO the RESTRICTIONS SPECIFIED under section 1.3., sub-section 1., clause .1
 *             .2 INCLUDE identical work IN OTHER GROUP PROJECTS
 *             .3 USE identical work IN YOUR OWN PROJECTS
 *             .4 GRANT PERMISSION for COMMERCIAL USE under YOUR CONDITIONS
 *                .1 SO LONG AS:
 *                   .1 The GRANTEE does not enact restrictions on FREE USE of YOUR WORK in any FASHION
 *                   .2 The GRANTEE ATTRIBUTES to you YOUR WORK
 *          .2 YOU MAY NOT
 *             .1 PUBLISH for PROFIT the works of OTHER AUTHORS as they are INCLUDED in GROUP PROJECTS that YOU MANAGE
 *             .2 CLAIM as YOURS the WORKS of OTHER AUTHORS as they are INCLUDED in GROUP PROJECTS that YOU MANAGE
 */

package pw.hysteria.input.dashfoo.command.parsing.impl;

import pw.hysteria.input.dashfoo.command.parsing.CommandFormattingProvider;
import pw.hysteria.input.dashfoo.command.parsing.CommandRegexProvider;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Creator: KingBowser
 * Date: 5/28/13
 * Time: 3:42 PM
 * Refer to LICENSE for licensing information
 */
public class SimpleRegexProvider implements CommandRegexProvider {

    private final CommandFormattingProvider configuration;

    private Pattern explosion;

    private Pattern flag;

    private Pattern handle;

    public SimpleRegexProvider(CommandFormattingProvider configuration) {
        this.configuration = configuration;

        recompile();
    }

    public void recompile() {

         /*
            <DEPRECATED> (?<=$IG_BEG) .+ (?=$IG_END) | (?<!$IG_BEG) [^$IG_BEG$EG_END$EXPLODE]+ (?!$IG_END)
            (?<!\\)(".*?)(?<!\\)"|([^|\s]+)
            Long-ass regex warning
         */
        explosion =
                Pattern.compile("(?<!" + configuration.getEscapeChar() + "{1})(" + configuration.getIgnoreChar() + ".*?)(?<!" + configuration.getEscapeChar() + "{1})\"|([^" + configuration.getExplodeChar() + "]+)");

//        System.out.println("Explosion pattern: " + explosion.toString());

        /*
            (?<!$ESCAPE)$FLAG[^$EXPLODE]+(?=$EXPLODE)
         */
        flag =
                Pattern.compile("(?<!" + configuration.getEscapeChar() + "{1})" + configuration.getFlagChar() + "([^" + configuration.getExplodeChar() + "]+)");

//        System.out.println("Flag pattern: " + flag.toString());

        /*
            ((?<=^-)[^\s]+)
            The handle is the first element - that's why this works
            This means we can capture the first element and then greedy the rest. This way Matcher is happy, and so it .matches()
         */
        handle =
                Pattern.compile("^" + configuration.getHandleChar() + "(\\w+)(.+)?");
//                Pattern.compile("^(.+)(.+)?");

        /*
            From a logical standpoint, validCommand should just be the handle with a greedy include
         */
//        validCommand = Pattern.compile("^" + configuration.getHandleChar() + "([\\w\\S]+).+");

//        System.out.println("Handle pattern:" + handle.toString());

    }


    @Override
    public Pattern getExplosionPattern() {
        return explosion;
    }

    @Override
    public Pattern getFlagPattern() {
        return flag;
    }

    @Override
    public Pattern getHandlePattern() {
        return handle;
    }

    @Override
    public String postProcessString(String post) {
        post = post.replaceAll("(?<!" + configuration.getEscapeChar() + ")" + configuration.getEscapeChar(), "");
        post = post.replaceAll("(?<!" + configuration.getEscapeChar() + ")" + configuration.getIgnoreChar(), "");
        return post;
    }

    @Override
    public boolean isCommand(String command) {

        return command.matches(getHandlePattern().pattern());

    }

    @Override
    public String getHandle(String command) {

        Matcher grepHandle = getHandlePattern().matcher(command);
        if (grepHandle.find())
            return grepHandle.group(1);
        else
            return null;

    }

    @Override
    public boolean isFlag(String flag) {
        return flag.matches(getFlagPattern().pattern());
    }

    @Override
    public String getFlag(String flag) {

        Matcher grepHandle = getFlagPattern().matcher(flag);
        if (grepHandle.find())
            return grepHandle.group(1);
        else
            return null;

    }

}
