/*
 * Decompiled with CFR 0.152.
 */
package pw.hysteria.input.dashfoo.command.parsing.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pw.hysteria.input.dashfoo.command.parsing.CommandFormattingProvider;
import pw.hysteria.input.dashfoo.command.parsing.CommandRegexProvider;

public class SimpleRegexProvider
implements CommandRegexProvider {
    private final CommandFormattingProvider configuration;
    private Pattern explosion;
    private Pattern flag;
    private Pattern handle;

    public SimpleRegexProvider(CommandFormattingProvider configuration) {
        this.configuration = configuration;
        this.recompile();
    }

    public void recompile() {
        this.explosion = Pattern.compile("(?<!" + this.configuration.getEscapeChar() + "{1})(" + this.configuration.getIgnoreChar() + ".*?)(?<!" + this.configuration.getEscapeChar() + "{1})\"|([^" + this.configuration.getExplodeChar() + "]+)");
        this.flag = Pattern.compile("(?<!" + this.configuration.getEscapeChar() + "{1})" + this.configuration.getFlagChar() + "([^" + this.configuration.getExplodeChar() + "]+)");
        this.handle = Pattern.compile("^" + this.configuration.getHandleChar() + "(\\w+)(.+)?");
    }

    @Override
    public Pattern getExplosionPattern() {
        return this.explosion;
    }

    @Override
    public Pattern getFlagPattern() {
        return this.flag;
    }

    @Override
    public Pattern getHandlePattern() {
        return this.handle;
    }

    @Override
    public String postProcessString(String post) {
        post = post.replaceAll("(?<!" + this.configuration.getEscapeChar() + ")" + this.configuration.getEscapeChar(), "");
        post = post.replaceAll("(?<!" + this.configuration.getEscapeChar() + ")" + this.configuration.getIgnoreChar(), "");
        return post;
    }

    @Override
    public boolean isCommand(String command) {
        return command.matches(this.getHandlePattern().pattern());
    }

    @Override
    public String getHandle(String command) {
        Matcher grepHandle = this.getHandlePattern().matcher(command);
        if (grepHandle.find()) {
            return grepHandle.group(1);
        }
        return null;
    }

    @Override
    public boolean isFlag(String flag) {
        return flag.matches(this.getFlagPattern().pattern());
    }

    @Override
    public String getFlag(String flag) {
        Matcher grepHandle = this.getFlagPattern().matcher(flag);
        if (grepHandle.find()) {
            return grepHandle.group(1);
        }
        return null;
    }
}

