/*
 * Decompiled with CFR 0.152.
 */
package pw.hysteria.input.dashfoo.command;

import java.util.HashMap;
import pw.hysteria.input.dashfoo.api.Initializes;
import pw.hysteria.input.dashfoo.command.Command;
import pw.hysteria.input.dashfoo.command.parsing.CommandRegexProvider;

public class CommandDispatcher {
    private final HashMap<String, Command> loadedCommands = new HashMap();
    private final CommandRegexProvider regexProvider;

    public CommandDispatcher(CommandRegexProvider regexProvider) {
        this.regexProvider = regexProvider;
    }

    public void registerCommand(Command command) throws Initializes.InitializationException {
        for (String handle : command.getHandles()) {
            if (!this.loadedCommands.keySet().contains(handle)) continue;
            throw new IllegalArgumentException("A supplied command contains overlapping handles");
        }
        command.initialize();
        for (String handle : command.getHandles()) {
            this.loadedCommands.put(handle, command);
        }
    }

    public void unRegisterCommand(Command command) {
        if (!this.loadedCommands.values().contains(command)) {
            throw new IllegalArgumentException("No such command is loaded");
        }
        for (String handle : command.getHandles()) {
            this.loadedCommands.remove(handle);
        }
    }

    public void dispatchCommand(String command) throws Command.CommandException {
        String handle = this.regexProvider.getHandle(command);
        if (!this.loadedCommands.containsKey(handle)) {
            throw new IllegalArgumentException("No such command (" + handle + ") exists");
        }
        this.loadedCommands.get(handle).invokeCommand(command);
    }

    public HashMap<String, Command> getLoadedCommands() {
        return new HashMap<String, Command>(this.loadedCommands);
    }
}

