/*
 * Decompiled with CFR 0.152.
 */
package pw.hysteria.input.dashfoo.command.impl;

import java.util.Map;
import pw.hysteria.api.spec.SuccessState;
import pw.hysteria.input.dashfoo.command.Command;
import pw.hysteria.input.dashfoo.command.FlagDispatcher;
import pw.hysteria.input.dashfoo.command.HelpProvider;
import pw.hysteria.input.dashfoo.command.NullHelpProvider;
import pw.hysteria.input.dashfoo.command.parsing.UserInputFlagParser;

public abstract class FlaggedCommand
extends Command {
    private final FlagDispatcher flagDispatcher;
    private HelpProvider helpContract = NullHelpProvider.PROVIDER;

    public FlaggedCommand(FlagDispatcher dispatcher) {
        this.flagDispatcher = dispatcher;
    }

    @Override
    public final SuccessState invokeCommand(String commandText) {
        Map<String, String[]> mappedInput = this.getFlagParser().mapUserInput(commandText);
        return this.flagDispatcher.dispatch(mappedInput);
    }

    @Override
    public final HelpProvider getHelpProvider() {
        return this.helpContract;
    }

    @Override
    public final SuccessState initialize() {
        return this.initCommand();
    }

    protected final FlagDispatcher getFlagDispatcher() {
        return this.flagDispatcher;
    }

    protected final void setHelpProvider(HelpProvider contract) {
        this.helpContract = contract;
    }

    protected abstract SuccessState initCommand();

    protected abstract UserInputFlagParser getFlagParser();
}

