/*
 * Decompiled with CFR 0.152.
 */
package pw.hysteria.input.dashfoo.command;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import pw.hysteria.api.spec.SuccessState;
import pw.hysteria.input.dashfoo.command.Flag;
import pw.hysteria.input.dashfoo.command.HasFlags;

public class FlagDispatcher
implements HasFlags {
    private final Map<String, Flag> invokableMap = new HashMap<String, Flag>();

    public void registerInvokable(Flag flag) {
        for (String handle : flag.getHandles()) {
            if (!this.getFlags().containsKey(handle)) continue;
            throw new IllegalArgumentException("Supplied flag has handles that overlap with another flag");
        }
        for (String handle : flag.getHandles()) {
            this.getFlags().put(handle, flag);
        }
    }

    public void unRegisterInvokable(Flag flag) {
        if (!this.getFlags().values().contains(flag)) {
            throw new IllegalArgumentException("Supplied flag is not registered.");
        }
        for (String handle : flag.getHandles()) {
            this.getFlags().remove(handle);
        }
    }

    public void addAll(Collection<? extends Flag> addFrom) {
        for (Flag flag : addFrom) {
            this.registerInvokable(flag);
        }
    }

    public SuccessState dispatch(Map<String, String[]> flagmap) {
        SuccessState calculatedResult = SuccessState.INDETERMINED;
        for (Map.Entry<String, String[]> entry : flagmap.entrySet()) {
            if (this.getFlags().containsKey(entry.getKey())) {
                SuccessState returnValue = this.getFlags().get(entry.getKey()).invoke(entry.getValue());
                if (calculatedResult == SuccessState.FAILURE || returnValue != SuccessState.FAILURE) continue;
                calculatedResult = SuccessState.FAILURE;
                continue;
            }
            throw new IllegalArgumentException("Non-existant flag passed to dispatcher");
        }
        return calculatedResult;
    }

    @Override
    public Map<String, Flag> getFlags() {
        return this.invokableMap;
    }
}

