/*
 * Decompiled with CFR 0.152.
 */
package pw.hysteria.input.dashfoo.command;

import java.util.HashMap;
import pw.hysteria.api.spec.SuccessState;
import pw.hysteria.input.dashfoo.command.Command;
import pw.hysteria.input.dashfoo.command.parsing.CommandRegexProvider;

public class CommandDispatcher {
    private final HashMap<String, Command> loadedCommands = new HashMap();
    private final CommandRegexProvider regexProvider;

    public CommandDispatcher(CommandRegexProvider regexProvider) {
        this.regexProvider = regexProvider;
    }

    public void registerCommand(Command command) {
        for (String handle : command.getHandles()) {
            if (!this.loadedCommands.keySet().contains(handle)) continue;
            throw new IllegalArgumentException("A supplied command contains overlapping handles");
        }
        command.initialize();
        for (String handle : command.getHandles()) {
            this.loadedCommands.put(handle, command);
        }
    }

    public void unRegisterCommand(Command command) {
        if (!this.loadedCommands.values().contains(command)) {
            throw new IllegalArgumentException("No such command is loaded");
        }
        for (String handle : command.getHandles()) {
            this.loadedCommands.remove(handle);
        }
    }

    public SuccessState dispatchCommand(String command) {
        String handle = this.regexProvider.getHandle(command);
        if (!this.loadedCommands.containsKey(handle)) {
            throw new IllegalArgumentException("No such command (" + handle + ") exists");
        }
        return this.loadedCommands.get(handle).invokeCommand(command);
    }
}

