/*
 * HYSTERIA GROUP LICENSE SPECIFICATION (1.2)
 * ================================================
 * An open-source-esque license that seeks to preserve some basic author rights whilst maintaining the integrity of an open-source project
 *
 * This license may also be applied to non-code works such as:
 * - Books
 * - Art
 * - Blueprints
 * - Movies
 *
 *
 * 1.1. Definitions
 *
 *     - THAT OF: Free
 *       - having no expressed cost
 *
 *     - THAT OF: Licensed
 *       - Any work that is expressed to be under this license
 *
 *     - THAT OF: Copyright
 *       - The right of someone to redistribute derivatives (or otherwise) of an original
 *
 *     - THAT OF: Intellectual Property
 *       - 1. The work of an individual, and the sole work thereof
 *       - 2. The work of a group of individuals, and the sole work thereof
 *
 * 1.2. Code Disclaimer(s)
 *
 *     1 ANY LICENSED code is provided as is
 *       .1 It is due to this that SHOULD any code within the LICENSED projects be in ANY way responsible for damages to a machine, or person(s) the AUTHOR is in no way responsible
 *       .2 This SHOULD NOT be NEGATED by an AUTHOR who has PUBLISHED under this LICENSE
 *
 * 1.3. License Restrictions
 *
 *     1. IN REGARDS TO: Licensing of derivatives and/or uses of the LICENSED work(s)
 *        .1 ANY derivative works MUST share the HGLSv*
 *        .2 ANY works that MAKE USE of the LICENSED work(s) must be published under the HGLSv*, a similar license, or a beerware-style license (so long as it preserves the HGLSv* values)
 *
 *     2. IN REGARDS TO: Cost
 *       .1 ALL derivative works MUST be free - no fees may be charged, unless you receive EXPRESSED PERMISSION from the AUTHOR
 *       .2 ANY works that MAKE USE of the LICENSED work(s) must also be FREE - no fees may be charged.
 *
 *     3. IN REGARDS TO: Intellectual property
 *        .N THIS license seeks to preserve the intellectual property of AUTHORS, whilst allowing such property to be freely re-used and distributed.
 *           IN ORDER to accomplish this, all USES AND DERIVATIVES must meet the following conditions
 *
 *       1. CREDIT FOR the work of ANY one AUTHOR must be preserved.
 *         .1 IF NO AUTHOR is specified DO NOT TAKE CREDIT. THIS is PUBLIC DOMAIN, and should REMAIN THAT WAY.
 *         .2 IF an AUTHOR is SPECIFIED, DO NOT CHANGE THE SPECIFIED AUTHOR's name UNDER ANY CONDITIONS
 *
 *       2. IF ADDING WORK of OTHER AUTHORS
 *          .1 INSURE that you are PERMITTED to DO SO
 *
 *       3. WHEN ADDING YOUR own WORK to a GROUP WORK
 *         .1 INSURE that YOU TAKE CREDIT for it
 *           .1 OTHERWISE, you are subject to section 1.3. , sub-section 3. , clause .1
 *         .2 SHOULD you be contributing to a LICENSED group work THAT
 *           .1 THE WORK shall remain under the HGLSv* LICENSE applied TO the GROUP WORK
 *           .2 IT IS THE DISCRETION of the PROJECT MANAGER whether or not YOUR WORK may be RELEASED from the LICENSE upon YOUR SOLE REQUEST
 *           .3 THE WORK shall BE IN YOUR NAME
 *              .1 SHOULD THE WORK be attributed to another FOR ANY REASON - that it is STILL YOUR WORK
 *                 .1 HOWEVER - YOU MUST speak with the PROJECT MANAGER in regards to the aforementioned MODIFICATION
 *
 *       4. AS AN AUTHOR (Author Rights)
 *          .1 YOU MAY
 *             .1 PUBLISH YOUR WORK under ANOTHER LICENSE, PURSUANT TO the RESTRICTIONS SPECIFIED under section 1.3., sub-section 1., clause .1
 *             .2 INCLUDE identical work IN OTHER GROUP PROJECTS
 *             .3 USE identical work IN YOUR OWN PROJECTS
 *             .4 GRANT PERMISSION for COMMERCIAL USE under YOUR CONDITIONS
 *                .1 SO LONG AS:
 *                   .1 The GRANTEE does not enact restrictions on FREE USE of YOUR WORK in any FASHION
 *                   .2 The GRANTEE ATTRIBUTES to you YOUR WORK
 *          .2 YOU MAY NOT
 *             .1 PUBLISH for PROFIT the works of OTHER AUTHORS as they are INCLUDED in GROUP PROJECTS that YOU MANAGE
 *             .2 CLAIM as YOURS the WORKS of OTHER AUTHORS as they are INCLUDED in GROUP PROJECTS that YOU MANAGE
 */

package pw.hysteria.input.dashfoo.command;

/**
 * Defines something with a binary state
 * <p/>
 * Creator: KingBowser
 * Date: 5/24/13
 * Time: 2:03 PM
 * Refer to LICENSE for licensing information
 */
public interface BinaryState {

    /**
     * Get the state of the toggle
     *
     * @return state
     */
    public ToggleState getState();

    /**
     * Describes the state of a toggle
     */
    public enum ToggleState {

        /*
            Returned if the toggle is on
         */
        ON,

        /*
            Returned if the toggle is off
         */
        OFF,

        /*
            Returned if the toggle cannot be toggled
         */
        STATIC
    }

}
