/*
 * Decompiled with CFR 0.152.
 */
package pw.forst.tools.katlib;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import pw.forst.tools.katlib.DateExtensionsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0012\u0010\b\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0014\u0010\n\u001a\u00020\u0007*\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a\u001c\u0010\r\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a\u0012\u0010\u000f\u001a\u00020\u0002*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\n\u0010\u0013\u001a\u00020\u0002*\u00020\u0010\u00a8\u0006\u0014"}, d2={"getDateRangeTo", "", "Ljava/time/LocalDate;", "to", "getDateRangeToAsStream", "Ljava/util/stream/Stream;", "getDayDifference", "", "getDaysInInterval", "getInvertedDateRangeToAsStream", "getWeekOfYear", "locale", "Ljava/util/Locale;", "setWeekOfYearMonday", "week", "toLocalDate", "Ljava/util/Date;", "zoneId", "Ljava/time/ZoneId;", "toUtcLocalDate", "katlib"})
public final class DateExtensionsKt {
    @NotNull
    public static final List<LocalDate> getDateRangeTo(@NotNull LocalDate $this$getDateRangeTo, @NotNull LocalDate to) {
        Intrinsics.checkNotNullParameter((Object)$this$getDateRangeTo, (String)"$this$getDateRangeTo");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return StreamsKt.toList(DateExtensionsKt.getDateRangeToAsStream($this$getDateRangeTo, to));
    }

    @NotNull
    public static final Stream<LocalDate> getDateRangeToAsStream(@NotNull LocalDate $this$getDateRangeToAsStream, @NotNull LocalDate to) {
        Intrinsics.checkNotNullParameter((Object)$this$getDateRangeToAsStream, (String)"$this$getDateRangeToAsStream");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Stream<LocalDate> stream = Stream.iterate($this$getDateRangeToAsStream, getDateRangeToAsStream.1.INSTANCE).limit($this$getDateRangeToAsStream.until(to, ChronoUnit.DAYS) + 1L);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"Stream\n        .iterate(\u2026to, ChronoUnit.DAYS) + 1)");
        return stream;
    }

    @NotNull
    public static final Stream<LocalDate> getInvertedDateRangeToAsStream(@NotNull LocalDate $this$getInvertedDateRangeToAsStream, @NotNull LocalDate to) {
        Intrinsics.checkNotNullParameter((Object)$this$getInvertedDateRangeToAsStream, (String)"$this$getInvertedDateRangeToAsStream");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Stream<LocalDate> stream = Stream.iterate($this$getInvertedDateRangeToAsStream, getInvertedDateRangeToAsStream.1.INSTANCE).limit(to.until($this$getInvertedDateRangeToAsStream, ChronoUnit.DAYS) + 1L);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"Stream\n        .iterate(\u2026is, ChronoUnit.DAYS) + 1)");
        return stream;
    }

    public static final int getWeekOfYear(@NotNull LocalDate $this$getWeekOfYear, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)$this$getWeekOfYear, (String)"$this$getWeekOfYear");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return $this$getWeekOfYear.get(WeekFields.of(locale).weekOfYear());
    }

    public static /* synthetic */ int getWeekOfYear$default(LocalDate localDate, Locale locale, int n, Object object) {
        if ((n & 1) != 0) {
            Locale locale2 = Locale.GERMANY;
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"Locale.GERMANY");
            locale = locale2;
        }
        return DateExtensionsKt.getWeekOfYear(localDate, locale);
    }

    @NotNull
    public static final LocalDate setWeekOfYearMonday(@NotNull LocalDate $this$setWeekOfYearMonday, int week, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)$this$setWeekOfYearMonday, (String)"$this$setWeekOfYearMonday");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        LocalDate localDate = $this$setWeekOfYearMonday.with(WeekFields.of(locale).weekOfYear(), week).with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"this\n    .with(WeekField\u2026OrSame(DayOfWeek.MONDAY))");
        return localDate;
    }

    public static /* synthetic */ LocalDate setWeekOfYearMonday$default(LocalDate localDate, int n, Locale locale, int n2, Object object) {
        if ((n2 & 2) != 0) {
            Locale locale2 = Locale.GERMANY;
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"Locale.GERMANY");
            locale = locale2;
        }
        return DateExtensionsKt.setWeekOfYearMonday(localDate, n, locale);
    }

    public static final int getDaysInInterval(@NotNull LocalDate $this$getDaysInInterval, @NotNull LocalDate to) {
        Intrinsics.checkNotNullParameter((Object)$this$getDaysInInterval, (String)"$this$getDaysInInterval");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Integer n = (int)ChronoUnit.DAYS.between($this$getDaysInInterval, to) + 1;
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        Integer n2 = it > 0 ? n : null;
        if (n2 == null) {
            throw (Throwable)new IllegalArgumentException("start date " + $this$getDaysInInterval + " is smaller than end date " + to + '.');
        }
        return n2;
    }

    public static final int getDayDifference(@NotNull LocalDate $this$getDayDifference, @NotNull LocalDate to) {
        Intrinsics.checkNotNullParameter((Object)$this$getDayDifference, (String)"$this$getDayDifference");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return (int)ChronoUnit.DAYS.between($this$getDayDifference, to);
    }

    @NotNull
    public static final LocalDate toLocalDate(@NotNull Date $this$toLocalDate, @NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)$this$toLocalDate, (String)"$this$toLocalDate");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        LocalDate localDate = LocalDate.from(Instant.ofEpochMilli($this$toLocalDate.getTime()).atZone(zoneId));
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"LocalDate.from(Instant.o\u2026his.time).atZone(zoneId))");
        return localDate;
    }

    @NotNull
    public static final LocalDate toUtcLocalDate(@NotNull Date $this$toUtcLocalDate) {
        Intrinsics.checkNotNullParameter((Object)$this$toUtcLocalDate, (String)"$this$toUtcLocalDate");
        ZoneId zoneId = ZoneId.of("UTC");
        Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"ZoneId.of(\"UTC\")");
        return DateExtensionsKt.toLocalDate($this$toUtcLocalDate, zoneId);
    }
}

