/*
 * Decompiled with CFR 0.152.
 */
package pw.forst.tools.katlib;

import java.io.File;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u00a8\u0006\u0007"}, d2={"hashWith256", "", "fileToHash", "Ljava/io/File;", "bytes", "", "textToHash", "katlib"})
public final class CryptoExtensionsKt {
    @NotNull
    public static final String hashWith256(@NotNull String textToHash) {
        Intrinsics.checkParameterIsNotNull((Object)textToHash, (String)"textToHash");
        String string = textToHash;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return CryptoExtensionsKt.hashWith256(byArray);
    }

    @NotNull
    public static final String hashWith256(@NotNull File fileToHash) {
        Intrinsics.checkParameterIsNotNull((Object)fileToHash, (String)"fileToHash");
        return CryptoExtensionsKt.hashWith256(FilesKt.readBytes((File)fileToHash));
    }

    @NotNull
    public static final String hashWith256(@NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        byte[] hashedArray = MessageDigest.getInstance("SHA-256").digest(bytes);
        String string = Base64.getEncoder().encodeToString(hashedArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Base64.getEncoder().encodeToString(hashedArray)");
        return string;
    }
}

