/*
 * Decompiled with CFR 0.152.
 */
package pw.forst.ktor.ratelimiting;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pw.forst.ktor.ratelimiting.DefaultValuesKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001fBC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\b\b\u0002\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0015\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u001a\u0010\u001d\u001a\u00020\u00142\b\u0010\u001e\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u000bH\u0002R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lpw/forst/ktor/ratelimiting/LinearRateLimiter;", "", "limit", "", "window", "Ljava/time/Duration;", "purgeHitSize", "", "purgeHitDuration", "nowProvider", "Lkotlin/Function0;", "Ljava/time/Instant;", "initialSize", "(JLjava/time/Duration;ILjava/time/Duration;Lkotlin/jvm/functions/Function0;I)V", "lastPurge", "purgeMutex", "Lkotlinx/coroutines/sync/Mutex;", "records", "Ljava/util/concurrent/ConcurrentMap;", "", "Lpw/forst/ktor/ratelimiting/LinearRateLimiter$RateLimit;", "defaultRate", "now", "processRequest", "remoteHost", "(Ljava/lang/String;)Ljava/lang/Long;", "purge", "", "purgeIfNecessary", "rateLimitOrDefault", "maybeRateLimit", "RateLimit", "ktor-ratelimiting"})
public final class LinearRateLimiter {
    private final long limit;
    @NotNull
    private final Duration window;
    private final int purgeHitSize;
    @NotNull
    private final Duration purgeHitDuration;
    @NotNull
    private final Function0<Instant> nowProvider;
    @NotNull
    private final ConcurrentMap<String, RateLimit> records;
    @NotNull
    private final Mutex purgeMutex;
    @NotNull
    private Instant lastPurge;

    public LinearRateLimiter(long limit, @NotNull Duration window, int purgeHitSize, @NotNull Duration purgeHitDuration, @NotNull Function0<Instant> nowProvider, int initialSize) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)purgeHitDuration, (String)"purgeHitDuration");
        Intrinsics.checkNotNullParameter(nowProvider, (String)"nowProvider");
        this.limit = limit;
        this.window = window;
        this.purgeHitSize = purgeHitSize;
        this.purgeHitDuration = purgeHitDuration;
        this.nowProvider = nowProvider;
        this.records = new ConcurrentHashMap(initialSize);
        this.purgeMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.lastPurge = (Instant)this.nowProvider.invoke();
    }

    public /* synthetic */ LinearRateLimiter(long l, Duration duration, int n, Duration duration2, Function0 function0, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n = 100;
        }
        if ((n3 & 8) != 0) {
            duration2 = DefaultValuesKt.getDEFAULT_PURGE_HIT_DURATION();
        }
        if ((n3 & 0x10) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n3 & 0x20) != 0) {
            n2 = 64;
        }
        this(l, duration, n, duration2, (Function0<Instant>)function0, n2);
    }

    @Nullable
    public final Long processRequest(@NotNull String remoteHost) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)remoteHost, (String)"remoteHost");
        Instant now = (Instant)this.nowProvider.invoke();
        RateLimit rate = this.records.compute(remoteHost, (arg_0, arg_1) -> LinearRateLimiter.processRequest$lambda-0(this, now, arg_0, arg_1));
        this.purgeIfNecessary(now);
        RateLimit rateLimit = rate;
        if (rateLimit == null) {
            l = null;
        } else {
            RateLimit rateLimit2 = rateLimit;
            boolean bl = false;
            boolean bl2 = false;
            RateLimit it = rateLimit2;
            boolean bl3 = false;
            l = it.getRemainingRequests().decrementAndGet() <= 0L ? Long.valueOf(it.getResetsAt().getEpochSecond() - now.getEpochSecond()) : null;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void purgeIfNecessary(Instant now) {
        boolean locked;
        if (this.records.size() > this.purgeHitSize && Duration.between(this.lastPurge, now).compareTo(this.purgeHitDuration) > 0 && (locked = Mutex.DefaultImpls.tryLock$default((Mutex)this.purgeMutex, null, (int)1, null))) {
            try {
                this.purge(now);
                this.lastPurge = now;
            }
            finally {
                Mutex.DefaultImpls.unlock$default((Mutex)this.purgeMutex, null, (int)1, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void purge(Instant now) {
        void $this$mapNotNullTo$iv$iv;
        Map $this$mapNotNull$iv = this.records;
        boolean $i$f$mapNotNull = false;
        Map map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var9_11 = $this$forEach$iv$iv$iv;
        boolean bl = false;
        Iterator iterator = var9_11.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry $dstr$key$rateLimit = element$iv$iv;
            boolean bl3 = false;
            Map.Entry entry = $dstr$key$rateLimit;
            boolean bl4 = false;
            String key = (String)entry.getKey();
            Map.Entry entry2 = $dstr$key$rateLimit;
            boolean bl5 = false;
            RateLimit rateLimit = (RateLimit)entry2.getValue();
            if ((rateLimit.getResetsAt().compareTo(now) <= 0 ? key : null) == null) continue;
            string = string;
            boolean bl6 = false;
            boolean bl7 = false;
            String it$iv$iv = string;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl9 = false;
            this.records.remove(it);
        }
    }

    private final RateLimit defaultRate(Instant now) {
        Instant instant = now.plus(this.window);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now.plus(window)");
        return new RateLimit(instant, new AtomicLong(this.limit));
    }

    private final RateLimit rateLimitOrDefault(RateLimit maybeRateLimit, Instant now) {
        return maybeRateLimit == null || maybeRateLimit.getResetsAt().compareTo(now) <= 0 ? this.defaultRate(now) : maybeRateLimit;
    }

    private static final RateLimit processRequest$lambda-0(LinearRateLimiter this$0, Instant $now, String $noName_0, RateLimit maybeRate) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$now, (String)"$now");
        return this$0.rateLimitOrDefault(maybeRate, $now);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lpw/forst/ktor/ratelimiting/LinearRateLimiter$RateLimit;", "", "resetsAt", "Ljava/time/Instant;", "remainingRequests", "Ljava/util/concurrent/atomic/AtomicLong;", "(Ljava/time/Instant;Ljava/util/concurrent/atomic/AtomicLong;)V", "getRemainingRequests", "()Ljava/util/concurrent/atomic/AtomicLong;", "getResetsAt", "()Ljava/time/Instant;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ktor-ratelimiting"})
    private static final class RateLimit {
        @NotNull
        private final Instant resetsAt;
        @NotNull
        private final AtomicLong remainingRequests;

        public RateLimit(@NotNull Instant resetsAt, @NotNull AtomicLong remainingRequests) {
            Intrinsics.checkNotNullParameter((Object)resetsAt, (String)"resetsAt");
            Intrinsics.checkNotNullParameter((Object)remainingRequests, (String)"remainingRequests");
            this.resetsAt = resetsAt;
            this.remainingRequests = remainingRequests;
        }

        @NotNull
        public final Instant getResetsAt() {
            return this.resetsAt;
        }

        @NotNull
        public final AtomicLong getRemainingRequests() {
            return this.remainingRequests;
        }

        @NotNull
        public final Instant component1() {
            return this.resetsAt;
        }

        @NotNull
        public final AtomicLong component2() {
            return this.remainingRequests;
        }

        @NotNull
        public final RateLimit copy(@NotNull Instant resetsAt, @NotNull AtomicLong remainingRequests) {
            Intrinsics.checkNotNullParameter((Object)resetsAt, (String)"resetsAt");
            Intrinsics.checkNotNullParameter((Object)remainingRequests, (String)"remainingRequests");
            return new RateLimit(resetsAt, remainingRequests);
        }

        public static /* synthetic */ RateLimit copy$default(RateLimit rateLimit, Instant instant, AtomicLong atomicLong, int n, Object object) {
            if ((n & 1) != 0) {
                instant = rateLimit.resetsAt;
            }
            if ((n & 2) != 0) {
                atomicLong = rateLimit.remainingRequests;
            }
            return rateLimit.copy(instant, atomicLong);
        }

        @NotNull
        public String toString() {
            return "RateLimit(resetsAt=" + this.resetsAt + ", remainingRequests=" + this.remainingRequests + ')';
        }

        public int hashCode() {
            int result = this.resetsAt.hashCode();
            result = result * 31 + this.remainingRequests.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RateLimit)) {
                return false;
            }
            RateLimit rateLimit = (RateLimit)other;
            if (!Intrinsics.areEqual((Object)this.resetsAt, (Object)rateLimit.resetsAt)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.remainingRequests, (Object)rateLimit.remainingRequests);
        }
    }
}

