/*
 * Decompiled with CFR 0.152.
 */
package com.jagrosh.jdautilities.examples.command;

import com.jagrosh.jdautilities.command.Command;
import com.jagrosh.jdautilities.command.CommandEvent;
import java.time.format.DateTimeFormatter;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.MessageBuilder;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;

public class ServerinfoCommand
extends Command {
    private static final String LINESTART = "\u25ab";
    private static final String GUILD_EMOJI = "\ud83d\udda5";
    private static final String NO_REGION = "\u2754";

    public ServerinfoCommand() {
        this.name = "serverinfo";
        this.aliases = new String[]{"server", "guildinfo"};
        this.help = "shows server info";
        this.botPermissions = new Permission[]{Permission.MESSAGE_EMBED_LINKS};
        this.guildOnly = true;
    }

    protected void execute(CommandEvent event) {
        String verif;
        Guild guild = event.getGuild();
        Member owner = guild.getOwner();
        long onlineCount = guild.getMembers().stream().filter(u -> u.getOnlineStatus() != OnlineStatus.OFFLINE).count();
        long botCount = guild.getMembers().stream().filter(m -> m.getUser().isBot()).count();
        EmbedBuilder builder = new EmbedBuilder();
        String title = ("\ud83d\udda5 Information about **" + guild.getName() + "**:").replace("@everyone", "@\u0435veryone").replace("@here", "@h\u0435re").replace("discord.gg/", "dis\u0441ord.gg/");
        switch (guild.getVerificationLevel()) {
            case VERY_HIGH: {
                verif = "\u253b\u2501\u253b\u30df\u30fd(\u0ca0\u76ca\u0ca0)\u30ce\u5f61\u253b\u2501\u253b";
                break;
            }
            case HIGH: {
                verif = "(\u256f\u00b0\u25a1\u00b0\uff09\u256f\ufe35 \u253b\u2501\u253b";
                break;
            }
            default: {
                verif = guild.getVerificationLevel().name();
            }
        }
        String str = "\u25abID: **" + guild.getId() + "**\n" + LINESTART + "Owner: " + (owner == null ? "Unknown" : "**" + owner.getUser().getName() + "**#" + owner.getUser().getDiscriminator()) + "\n" + LINESTART + "Location: " + (guild.getRegion().getEmoji().isEmpty() ? NO_REGION : guild.getRegion().getEmoji()) + " **" + guild.getRegion().getName() + "**\n" + LINESTART + "Creation: **" + guild.getTimeCreated().format(DateTimeFormatter.RFC_1123_DATE_TIME) + "**\n" + LINESTART + "Users: **" + guild.getMemberCache().size() + "** (" + onlineCount + " online, " + botCount + " bots)\n" + LINESTART + "Channels: **" + guild.getTextChannelCache().size() + "** Text, **" + guild.getVoiceChannelCache().size() + "** Voice, **" + guild.getCategoryCache().size() + "** Categories\n" + LINESTART + "Verification: **" + verif + "**";
        if (!guild.getFeatures().isEmpty()) {
            str = str + "\n\u25abFeatures: **" + String.join((CharSequence)"**, **", guild.getFeatures()) + "**";
        }
        if (guild.getSplashId() != null) {
            builder.setImage(guild.getSplashUrl() + "?size=1024");
            str = str + "\n\u25abSplash: ";
        }
        if (guild.getIconUrl() != null) {
            builder.setThumbnail(guild.getIconUrl());
        }
        builder.setColor(owner == null ? null : owner.getColor());
        builder.setDescription((CharSequence)str);
        event.reply(new MessageBuilder().append((CharSequence)title).setEmbed(builder.build()).build());
    }
}

