/*
 * Decompiled with CFR 0.152.
 */
package pw.binom.kotlin.clang;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.internal.impldep.org.apache.commons.compress.archivers.ArchiveEntry;
import org.gradle.internal.impldep.org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.gradle.internal.impldep.org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import pw.binom.kotlin.clang.CompilerUtilsKt;
import pw.binom.kotlin.clang.Konan;
import pw.binom.kotlin.clang.StreamGobblerAppendable;
import pw.binom.kotlin.clang.TargetInfo;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004J\u0016\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R#\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\t\u0010\u0006R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lpw/binom/kotlin/clang/Konan;", "", "()V", "KONAN_EXE_PATH", "Ljava/io/File;", "getKONAN_EXE_PATH", "()Ljava/io/File;", "TMP_SOURCE_FILE", "kotlin.jvm.PlatformType", "getTMP_SOURCE_FILE", "TMP_SOURCE_FILE$delegate", "Lkotlin/Lazy;", "prebuildDir", "checkKonanInstalled", "", "checkSysrootInstalled", "target", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "unpackTargz", "stream", "Ljava/io/InputStream;", "dest", "unpackZip", "kn-clang"})
public final class Konan {
    @NotNull
    public static final Konan INSTANCE = new Konan();
    @NotNull
    private static final Lazy TMP_SOURCE_FILE$delegate = LazyKt.lazy((Function0)TMP_SOURCE_FILE.2.INSTANCE);
    @NotNull
    private static final File prebuildDir = FilesKt.resolve((File)CompilerUtilsKt.getKONAN_USER_DIR(), (String)CompilerUtilsKt.getPREBUILD_KONAN_DIR_NAME());
    @NotNull
    private static final File KONAN_EXE_PATH;

    private Konan() {
    }

    private final File getTMP_SOURCE_FILE() {
        Lazy lazy = TMP_SOURCE_FILE$delegate;
        return (File)lazy.getValue();
    }

    @NotNull
    public final File getKONAN_EXE_PATH() {
        return KONAN_EXE_PATH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkKonanInstalled() {
        block18: {
            String string;
            if (prebuildDir.isDirectory()) {
                return;
            }
            System.out.println((Object)"Please wait while Kotlin/Native compiler 1.6.0 is being installed.");
            String arch = System.getProperty("os.arch");
            if (HostManager.Companion.getHostIsLinux()) {
                string = "https:  //github.com/JetBrains/kotlin/releases/download/v1.6.10/kotlin-native-linux-x86_64-1.6.10.tar.gz";
            } else if (HostManager.Companion.getHostIsMac() && Intrinsics.areEqual((Object)arch, (Object)"aarch64")) {
                string = "https://github.com/JetBrains/kotlin/releases/download/v1.6.10/kotlin-native-macos-aarch64-1.6.10.tar.gz";
            } else if (HostManager.Companion.getHostIsMac()) {
                string = "https://github.com/JetBrains/kotlin/releases/download/v1.6.10/kotlin-native-macos-x86_64-1.6.10.tar.gz";
            } else if (HostManager.Companion.getHostIsMingw()) {
                string = "https://github.com/JetBrains/kotlin/releases/download/v1.6.10/kotlin-native-windows-x86_64-1.6.10.zip";
            } else {
                throw new RuntimeException("Unsupported host " + HostManager.Companion.hostOs() + ':' + HostManager.Companion.hostArch());
            }
            String url = string;
            URLConnection uRLConnection = new URL(url).openConnection();
            if (uRLConnection == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            try {
                if (connection.getResponseCode() != 200) {
                    throw new RuntimeException("Can't download konan from \"" + url + "\". Invalid response code: " + connection.getResponseCode());
                }
                try {
                    if (StringsKt.endsWith$default((String)url, (String)".tar.gz", (boolean)false, (int)2, null)) {
                        InputStream inputStream = connection.getInputStream();
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"connection.inputStream");
                        this.unpackTargz(inputStream, prebuildDir);
                        break block18;
                    }
                    if (StringsKt.endsWith$default((String)url, (String)".zip", (boolean)false, (int)2, null)) {
                        InputStream inputStream = connection.getInputStream();
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"connection.inputStream");
                        this.unpackZip(inputStream, prebuildDir);
                        break block18;
                    }
                    throw new RuntimeException("Unsupported archive \"" + url + '\"');
                }
                catch (Throwable e) {
                    throw new RuntimeException("Can't unpack konan", e);
                }
            }
            finally {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void checkSysrootInstalled(@NotNull KonanTarget target) {
        List list;
        Object $this$map$iv;
        Object[] objectArray;
        File it;
        boolean bl;
        TargetInfo info;
        block13: {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.checkKonanInstalled();
            TargetInfo targetInfo = CompilerUtilsKt.getTargetInfoMap().get(target);
            if (targetInfo == null) {
                throw new RuntimeException("Target \"" + target.getName() + "\" not supported");
            }
            info = targetInfo;
            Iterable $this$all$iv = info.getSysRoot();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (File)element$iv;
                    boolean bl2 = false;
                    if (it.isDirectory()) continue;
                    bl = false;
                    break block13;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        Iterable $this$forEach$iv = info.getSysRoot();
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (File)element$iv;
            boolean bl3 = false;
            System.out.println((Object)(it + " -> " + it.isDirectory()));
        }
        System.out.println((Object)("Please wait while Sysroot " + target.getName() + " is being installed."));
        Object[] $i$f$forEach22 = new String[]{"-target", target.getName(), this.getTMP_SOURCE_FILE().getAbsolutePath()};
        List args = CollectionsKt.listOf((Object[])$i$f$forEach22);
        if (HostManager.Companion.getHostIsLinux() || HostManager.Companion.getHostIsMac()) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            Object element$iv;
            objectArray = new String[3];
            objectArray[0] = "bash";
            objectArray[1] = "-c";
            element$iv = args;
            StringBuilder stringBuilder = new StringBuilder().append('\'').append((Object)KONAN_EXE_PATH.getAbsolutePath()).append("' ");
            int n = 2;
            Object[] objectArray2 = objectArray;
            boolean $i$f$map = false;
            void bl3 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add("" + '\'' + it2 + '\'');
            }
            collection = (List)destination$iv$iv;
            objectArray2[n] = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)).toString();
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (HostManager.Companion.getHostIsMingw()) {
            objectArray = new String[]{"cmd", "/c", KONAN_EXE_PATH.getAbsolutePath()};
            list = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)args);
        } else {
            throw new RuntimeException("Current platform is not supported");
        }
        List startArg = list;
        System.out.println((Object)Intrinsics.stringPlus((String)"Executing ", (Object)startArg));
        System.out.println((Object)Intrinsics.stringPlus((String)"in ", (Object)this.getTMP_SOURCE_FILE().getParentFile()));
        Collection $this$toTypedArray$iv = startArg;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        $this$map$iv = stringArray;
        ProcessBuilder pb = new ProcessBuilder(Arrays.copyOf($this$map$iv, ((String[])$this$map$iv).length));
        pb.directory(this.getTMP_SOURCE_FILE().getParentFile());
        Map<String, String> map = pb.environment();
        $this$map$iv = System.getenv();
        Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv, (String)"getenv()");
        map.putAll((Map<String, String>)$this$map$iv);
        pb.redirectOutput(ProcessBuilder.Redirect.PIPE);
        pb.redirectError(ProcessBuilder.Redirect.PIPE);
        Process process = pb.start();
        Closeable closeable = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)closeable, (String)"process.inputStream");
        InputStream inputStream = closeable;
        closeable = System.out;
        Intrinsics.checkNotNullExpressionValue((Object)closeable, (String)"out");
        new StreamGobblerAppendable(inputStream, (Appendable)((Object)closeable), false).start();
        closeable = process.getErrorStream();
        Intrinsics.checkNotNullExpressionValue((Object)closeable, (String)"process.errorStream");
        Closeable closeable2 = closeable;
        closeable = System.err;
        Intrinsics.checkNotNullExpressionValue((Object)closeable, (String)"err");
        new StreamGobblerAppendable((InputStream)closeable2, (Appendable)((Object)closeable), false).start();
        process.waitFor();
        if (process.exitValue() != 0) {
            throw new RuntimeException("Can't execute konan");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unpackTargz(@NotNull InputStream stream, @NotNull File dest) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Closeable closeable = (Closeable)new GzipCompressorInputStream(stream);
        Throwable throwable = null;
        try {
            GzipCompressorInputStream gzip = (GzipCompressorInputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)new TarArchiveInputStream((InputStream)gzip);
            Throwable throwable2 = null;
            try {
                TarArchiveInputStream tar = (TarArchiveInputStream)closeable2;
                boolean bl2 = false;
                ArchiveEntry entry = tar.getNextEntry();
                while (entry != null) {
                    Object object = entry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"entry.name");
                    File entryFile = FilesKt.resolve((File)dest, (String)object);
                    if (entry.isDirectory()) {
                        if (!entryFile.mkdirs()) {
                            throw new RuntimeException(Intrinsics.stringPlus((String)"Failed to create ", (Object)entryFile));
                        }
                    } else {
                        object = new FileOutputStream(entryFile);
                        Throwable throwable3 = null;
                        try {
                            int len;
                            FileOutputStream fos = (FileOutputStream)object;
                            boolean bl3 = false;
                            byte[] buffer = new byte[8192];
                            while ((len = tar.read(buffer)) > 0) {
                                fos.write(buffer, 0, len);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable3);
                        }
                    }
                    entry = tar.getNextEntry();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unpackZip(@NotNull InputStream stream, @NotNull File dest) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Closeable closeable = new ZipInputStream(stream);
        Throwable throwable = null;
        try {
            ZipInputStream zip = (ZipInputStream)closeable;
            boolean bl = false;
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                Object object = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"entry.name");
                File entryFile = FilesKt.resolve((File)dest, (String)object);
                if (entry.isDirectory()) {
                    if (!entryFile.mkdirs()) {
                        throw new RuntimeException(Intrinsics.stringPlus((String)"Failed to create ", (Object)entryFile));
                    }
                } else {
                    object = new FileOutputStream(entryFile);
                    Throwable throwable2 = null;
                    try {
                        int len;
                        FileOutputStream fos = (FileOutputStream)object;
                        boolean bl2 = false;
                        byte[] buffer = new byte[8192];
                        while ((len = zip.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                    }
                }
                entry = zip.getNextEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static {
        Konan $this$KONAN_EXE_PATH_u24lambda_u2d0 = INSTANCE;
        boolean bl = false;
        File binFolder = FilesKt.resolve((File)prebuildDir, (String)"bin");
        KONAN_EXE_PATH = HostManager.Companion.getHostIsMingw() ? FilesKt.resolve((File)binFolder, (String)"kotlinc-native.bat") : FilesKt.resolve((File)binFolder, (String)"kotlinc-native");
    }
}

