/*
 * Decompiled with CFR 0.152.
 */
package pw.avvero.test.kafka;

import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Headers;
import pw.avvero.test.kafka.RecordCaptor;
import pw.avvero.test.kafka.RecordSnapshot;
import pw.avvero.test.kafka.RecordSnapshotMapper;

public class RecordCaptorConsumer {
    private static final Logger log = LoggerFactory.getLogger(RecordCaptorConsumer.class);
    private final RecordCaptor recordCaptor;
    private final RecordSnapshotMapper mapper;

    @KafkaListener(id="recordCaptor", topics={"#{'${test.record-captor.topics}'.split(',')}"}, groupId="test")
    public void eventCaptorListener(ConsumerRecord<Object, Object> record, @Headers Map<String, Object> boundedHeaders) {
        RecordSnapshot recordSnapshot = this.mapper.recordToSnapshot(record, boundedHeaders);
        this.recordCaptor.capture(recordSnapshot);
    }

    public RecordCaptor getRecordCaptor() {
        return this.recordCaptor;
    }

    public RecordSnapshotMapper getMapper() {
        return this.mapper;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecordCaptorConsumer)) {
            return false;
        }
        RecordCaptorConsumer other = (RecordCaptorConsumer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RecordCaptor this$recordCaptor = this.getRecordCaptor();
        RecordCaptor other$recordCaptor = other.getRecordCaptor();
        if (this$recordCaptor == null ? other$recordCaptor != null : !this$recordCaptor.equals(other$recordCaptor)) {
            return false;
        }
        RecordSnapshotMapper this$mapper = this.getMapper();
        RecordSnapshotMapper other$mapper = other.getMapper();
        return !(this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RecordCaptorConsumer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RecordCaptor $recordCaptor = this.getRecordCaptor();
        result = result * 59 + ($recordCaptor == null ? 43 : $recordCaptor.hashCode());
        RecordSnapshotMapper $mapper = this.getMapper();
        result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
        return result;
    }

    public String toString() {
        return "RecordCaptorConsumer(recordCaptor=" + this.getRecordCaptor() + ", mapper=" + this.getMapper() + ")";
    }

    public RecordCaptorConsumer(RecordCaptor recordCaptor, RecordSnapshotMapper mapper) {
        this.recordCaptor = recordCaptor;
        this.mapper = mapper;
    }
}

