/*
 * Decompiled with CFR 0.152.
 */
package pw.avvero.test.kafka;

import org.apache.kafka.common.TopicPartition;

public class OffsetSnapshotFrame {
    private final StringBuilder sb = new StringBuilder("[KTS] Offset comparison frame\n");

    public OffsetSnapshotFrame() {
        this.sb.append(" ______________________________________________________________________________________________________\n");
        this.sb.append("| Consumer group             | Partition                                              | CGF    | PO    |\n");
    }

    public void append(String consumerGroup, TopicPartition topicPartition, Long consumerGroupOffset, Long partitionOffset) {
        boolean equal = partitionOffset == null || partitionOffset == 0L || partitionOffset.equals(consumerGroupOffset);
        char[] frameRow = "| cg                         | t                                                      | o      | o     |          \n".toCharArray();
        this.replace(frameRow, 2, 27, consumerGroup);
        this.replace(frameRow, 31, 84, topicPartition.toString());
        this.replace(frameRow, 88, 92, consumerGroupOffset.toString());
        this.replace(frameRow, 97, 102, partitionOffset != null ? partitionOffset.toString() : " ");
        this.replace(frameRow, 104, 108, equal ? "   " : "<-- error");
        this.sb.append(new String(frameRow));
    }

    public void split() {
        this.sb.append(" ______________________________________________________________________________________________________\n");
    }

    public String toString() {
        return this.sb.toString();
    }

    private void replace(char[] target, int s, int e, String substring) {
        int i;
        int length = Math.min(e - s + 1, substring.length());
        for (i = 0; i < length; ++i) {
            target[s + i] = substring.charAt(i);
        }
        for (i = length; i < e - s + 1; ++i) {
            target[s + i] = 32;
        }
    }
}

