/*
 * Decompiled with CFR 0.152.
 */
package pw.avvero.emk;

import com.github.dockerjava.api.command.InspectContainerResponse;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.DockerImageName;

public class EmbeddedKafkaContainer
extends GenericContainer<EmbeddedKafkaContainer> {
    public static final int HTTP_PORT = 8080;
    public static final int KAFKA_PORT = 9093;
    public static final int ZOOKEEPER_PORT = 2181;
    private static final String STARTER_SCRIPT = "/testcontainers_start.sh";
    private final String imageName;

    public EmbeddedKafkaContainer(String imageName) {
        super(DockerImageName.parse((String)imageName));
        this.imageName = imageName;
        this.addExposedPort(8080);
        this.addExposedPort(9093);
        this.addExposedPort(2181);
        this.setCommand(new String[]{"/bin/sh", "-c", "while [ ! -f /testcontainers_start.sh ]; do echo 'Waiting for start kafka'; sleep 0.1; done; /testcontainers_start.sh"});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Waiting for start kafka.*", (int)1));
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        String brokerAdvertisedListener = this.brokerAdvertisedListener(containerInfo);
        String advertisedListeners = String.join((CharSequence)",", this.getBootstrapServers(), brokerAdvertisedListener);
        String command = "#!/bin/bash\n" + (this.imageName.contains("native") ? "/app/emk-application" : "./emk-application-boot/bin/emk-application") + " --app.kafka.startup-mode=at-once --app.kafka.advertised.listeners=" + advertisedListeners;
        this.copyFileToContainer(Transferable.of((String)command, (int)511), STARTER_SCRIPT);
    }

    public String getBootstrapServers() {
        return String.format("PLAINTEXT://%s:%s", this.getHost(), this.getMappedPort(9093));
    }

    protected String brokerAdvertisedListener(InspectContainerResponse containerInfo) {
        return String.format("BROKER://%s:%s", containerInfo.getConfig().getHostName(), "9092");
    }
}

