/*
 * Decompiled with CFR 0.152.
 */
package pw.avvero.emk;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class EmbeddedKafkaContainer
extends GenericContainer<EmbeddedKafkaContainer> {
    public static final int HTTP_PORT = 8080;
    public static final int KAFKA_PORT = 9093;
    public static final int ZOOKEEPER_PORT = 2181;

    public EmbeddedKafkaContainer(String fullImageName) {
        super(DockerImageName.parse((String)fullImageName));
        this.addExposedPort(8080);
        this.addExposedPort(9093);
        this.addExposedPort(2181);
        this.withEnv("app.kafka.startup-mode", "on-demand");
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Started Application in.*\\n", (int)1));
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        String brokerAdvertisedListener = this.brokerAdvertisedListener(containerInfo);
        String advertisedListeners = String.join((CharSequence)",", this.getBootstrapServers(), brokerAdvertisedListener);
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder(URI.create(String.format("http://%s:%s/kafka/start", this.getHost(), this.getMappedPort(8080)))).headers("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(String.format("{\"advertisedListeners\": \"%s\"}", advertisedListeners))).build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            throw new IllegalStateException(String.format("Can't start kafka on demand: http code %s", response.statusCode()));
        }
    }

    public String getBootstrapServers() {
        return String.format("PLAINTEXT://%s:%s", this.getHost(), this.getMappedPort(9093));
    }

    protected String brokerAdvertisedListener(InspectContainerResponse containerInfo) {
        return String.format("BROKER://%s:%s", containerInfo.getConfig().getHostName(), "9092");
    }
}

