/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.utils.ipc.client.builder.socket;

import java.net.InetAddress;
import java.net.Socket;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import pw.aru.utils.io.DataPipe;
import pw.aru.utils.io.DataPipeStream;
import pw.aru.utils.ipc.client.connector.ClientConnection;
import pw.aru.utils.ipc.client.connector.ClientConnector;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lpw/aru/utils/ipc/client/builder/socket/SocketConnector;", "Lpw/aru/utils/ipc/client/connector/ClientConnector;", "Ljava/net/Socket;", "address", "Ljava/net/InetAddress;", "port", "", "(Ljava/net/InetAddress;I)V", "createConnection", "Lpw/aru/utils/ipc/client/connector/ClientConnection;", "toString", "", "simple-ipc"})
public final class SocketConnector
implements ClientConnector<Socket> {
    private final InetAddress address;
    private final int port;

    @Override
    @NotNull
    public ClientConnection<Socket> createConnection() {
        Socket socket = new Socket(this.address, this.port);
        return new ClientConnection<Socket>(socket, (DataPipe)new DataPipeStream(socket.getInputStream(), socket.getOutputStream()));
    }

    @NotNull
    public String toString() {
        return "SocketConnector[" + this.address + ':' + this.port + ']';
    }

    public SocketConnector(@NotNull InetAddress address, int port) {
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        this.address = address;
        int n = this.port = port;
        int n2 = n = 1 <= n && 65535 >= n ? 1 : 0;
        if (n == 0) {
            String string = this.port + " is not a valid port";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }
}

