/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.utils.ipc.client.builder.socket;

import java.net.InetAddress;
import java.net.Socket;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import pw.aru.utils.ipc.client.builder.ClientBuilder;
import pw.aru.utils.ipc.client.builder.socket.SocketConnector;
import pw.aru.utils.ipc.proto.Protocol;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\bJ\b\u0010\t\u001a\u00020\nH\u0014J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lpw/aru/utils/ipc/client/builder/socket/SocketClientBuilder;", "Lpw/aru/utils/ipc/client/builder/ClientBuilder;", "Ljava/net/Socket;", "()V", "address", "Ljava/net/InetAddress;", "port", "", "", "buildConnector", "Lpw/aru/utils/ipc/client/builder/socket/SocketConnector;", "protocol", "Lpw/aru/utils/ipc/proto/Protocol;", "simple-ipc"})
public final class SocketClientBuilder
extends ClientBuilder<Socket> {
    private InetAddress address;
    private int port;

    @NotNull
    public SocketClientBuilder protocol(@NotNull Protocol protocol) {
        SocketClientBuilder socketClientBuilder;
        Intrinsics.checkParameterIsNotNull((Object)protocol, (String)"protocol");
        SocketClientBuilder $receiver = socketClientBuilder = this;
        super.protocol(protocol);
        return socketClientBuilder;
    }

    @NotNull
    public final SocketClientBuilder address(@NotNull InetAddress address) {
        SocketClientBuilder socketClientBuilder;
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        SocketClientBuilder $receiver = socketClientBuilder = this;
        $receiver.address = address;
        return socketClientBuilder;
    }

    @NotNull
    public final SocketClientBuilder address(@NotNull String address) {
        SocketClientBuilder socketClientBuilder;
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        SocketClientBuilder $receiver = socketClientBuilder = this;
        InetAddress inetAddress = InetAddress.getByName(address);
        Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress, (String)"InetAddress.getByName(address)");
        $receiver.address = inetAddress;
        return socketClientBuilder;
    }

    @NotNull
    public final SocketClientBuilder port(int port) {
        SocketClientBuilder socketClientBuilder;
        SocketClientBuilder $receiver = socketClientBuilder = this;
        int n = port;
        int n2 = n = 1 <= n && 65535 >= n ? 1 : 0;
        if (n == 0) {
            String string = port + " is not a valid port";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        $receiver.port = port;
        return socketClientBuilder;
    }

    @NotNull
    protected SocketConnector buildConnector() {
        return new SocketConnector(this.address, this.port);
    }

    public SocketClientBuilder() {
        InetAddress inetAddress = InetAddress.getLocalHost();
        Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress, (String)"InetAddress.getLocalHost()");
        this.address = inetAddress;
        this.port = -1;
    }
}

