/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.utils.ipc.server.connector.socket;

import java.net.ServerSocket;
import java.net.Socket;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import pw.aru.utils.io.DataPipe;
import pw.aru.utils.io.DataPipeStream;
import pw.aru.utils.ipc.server.connector.ServerConnection;
import pw.aru.utils.ipc.server.connector.ServerConnector;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lpw/aru/utils/ipc/server/connector/socket/SocketConnector;", "Lpw/aru/utils/ipc/server/connector/ServerConnector;", "Ljava/net/Socket;", "port", "", "backlog", "(II)V", "server", "Ljava/net/ServerSocket;", "awaitNextConnection", "Lpw/aru/utils/ipc/server/connector/ServerConnection;", "shutdown", "", "simple-ipc"})
public final class SocketConnector
implements ServerConnector<Socket> {
    private final ServerSocket server;

    @Override
    @NotNull
    public ServerConnection<Socket> awaitNextConnection() {
        Socket socket;
        Socket socket2 = socket = this.server.accept();
        Intrinsics.checkExpressionValueIsNotNull((Object)socket2, (String)"socket");
        return new ServerConnection<Socket>(socket2, (DataPipe)new DataPipeStream(socket.getInputStream(), socket.getOutputStream()));
    }

    @Override
    public void shutdown() {
        this.server.close();
    }

    public SocketConnector(int port, int backlog) {
        int n = port;
        int n2 = n = 1 <= n && 65535 >= n ? 1 : 0;
        if (n == 0) {
            String string = port + " is not a valid port";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        n = backlog;
        int n3 = n = 1 <= n && 65535 >= n ? 1 : 0;
        if (n == 0) {
            String string = backlog + " is not a valid backlog size";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.server = new ServerSocket(port, backlog);
    }
}

