/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.utils.ipc.client.impl;

import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pw.aru.utils.io.DataPipe;
import pw.aru.utils.ipc.client.IClient;
import pw.aru.utils.ipc.client.IClientPool;
import pw.aru.utils.ipc.client.connector.ClientConnector;
import pw.aru.utils.ipc.client.impl.ClientImpl;
import pw.aru.utils.ipc.proto.ConnectionState;
import pw.aru.utils.ipc.proto.Protocol;
import pw.aru.utils.ipc.proto.ProtocolChecksKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001&B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\bH\u0002J\u0012\u0010\"\u001a\f0\u0018R\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0002J\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001cH\u0002R\u0014\u0010\f\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u0012\u0012\u000e\u0012\f0\u0018R\b\u0012\u0004\u0012\u00028\u00000\u00000\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lpw/aru/utils/ipc/client/impl/ClientPoolImpl;", "T", "Lpw/aru/utils/ipc/client/IClientPool;", "protocol", "Lpw/aru/utils/ipc/proto/Protocol;", "connector", "Lpw/aru/utils/ipc/client/connector/ClientConnector;", "queueSize", "", "buildInitial", "", "(Lpw/aru/utils/ipc/proto/Protocol;Lpw/aru/utils/ipc/client/connector/ClientConnector;IZ)V", "available", "getAvailable", "()I", "closed", "getConnector", "()Lpw/aru/utils/ipc/client/connector/ClientConnector;", "created", "maxCreated", "getProtocol", "()Lpw/aru/utils/ipc/proto/Protocol;", "queue", "Ljava/util/Queue;", "Lpw/aru/utils/ipc/client/impl/ClientPoolImpl$PoolClient;", "queueLock", "", "borrowClient", "Lpw/aru/utils/ipc/client/IClient;", "cleanup", "", "close", "launchCleanup", "lastMaxCreated", "makeClient", "toString", "", "tryPoll", "PoolClient", "simple-ipc"})
public final class ClientPoolImpl<T>
implements IClientPool<T> {
    private boolean closed;
    private final Queue<PoolClient> queue;
    private final Object queueLock;
    private int created;
    private int maxCreated;
    @NotNull
    private final Protocol protocol;
    @NotNull
    private final ClientConnector<T> connector;

    private final PoolClient makeClient() {
        return new PoolClient(new ClientImpl<T>(this.protocol, this.connector));
    }

    @Override
    public int getAvailable() {
        return this.queue.size();
    }

    @Override
    @NotNull
    public IClient<T> borrowClient() {
        IClient<T> client = this.tryPoll();
        if (client == null) {
            int n;
            int n2 = this.created;
            this.created = n2 + 1;
            n2 = this.maxCreated;
            int n3 = this.created;
            ClientPoolImpl clientPoolImpl = this;
            clientPoolImpl.maxCreated = n = Math.max(n2, n3);
            return this.makeClient();
        }
        this.created = 0;
        return client;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        this.closed = true;
        int n = 0;
        int n2 = this.queue.size();
        if (n <= n2) {
            while (true) {
                void i;
                try {
                    IClient iClient = this.queue.poll();
                    if (iClient != null && (iClient = ((PoolClient)iClient).getClient()) != null) {
                        iClient.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (i == n2) break;
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void cleanup() {
        int n = 0;
        int n2 = this.queue.size() / 2;
        if (n <= n2) {
            while (true) {
                void i;
                try {
                    IClient iClient = this.queue.poll();
                    if (iClient != null && (iClient = ((PoolClient)iClient).getClient()) != null) {
                        iClient.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (i == n2) break;
                ++i;
            }
        }
    }

    private final IClient<T> tryPoll() {
        IClient client;
        if (this.closed) {
            throw (Throwable)new IllegalStateException("pool closed");
        }
        while (true) {
            PoolClient poolClient = this.queue.poll();
            if (poolClient == null) {
                return null;
            }
            client = poolClient;
            if (client.isAlive() && client.isIdle()) break;
            try {
                client.close();
            }
            catch (Exception exception) {}
        }
        return client;
    }

    private final void launchCleanup(int lastMaxCreated) {
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"IPCClientPool-CleanupThread", (int)0, (Function0)((Function0)new Function0<Unit>(this, lastMaxCreated){
            final /* synthetic */ ClientPoolImpl this$0;
            final /* synthetic */ int $lastMaxCreated;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                int n = 0;
                int n2 = this.this$0.getAvailable() - this.$lastMaxCreated;
                if (n <= n2) {
                    while (true) {
                        void i;
                        try {
                            IClient<T> iClient = (PoolClient)ClientPoolImpl.access$getQueue$p(this.this$0).poll();
                            if (iClient != null && (iClient = ((PoolClient)iClient).getClient()) != null) {
                                iClient.close();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (i == n2) break;
                        ++i;
                    }
                }
            }
            {
                this.this$0 = clientPoolImpl;
                this.$lastMaxCreated = n;
                super(0);
            }
        }), (int)23, null);
    }

    @NotNull
    public String toString() {
        return this.connector + ".ClientPool with " + this.getAvailable() + " available clients";
    }

    @NotNull
    public final Protocol getProtocol() {
        return this.protocol;
    }

    @NotNull
    public final ClientConnector<T> getConnector() {
        return this.connector;
    }

    public ClientPoolImpl(@NotNull Protocol protocol, @NotNull ClientConnector<T> connector, int queueSize, boolean buildInitial) {
        Intrinsics.checkParameterIsNotNull((Object)protocol, (String)"protocol");
        Intrinsics.checkParameterIsNotNull(connector, (String)"connector");
        this.protocol = protocol;
        this.connector = connector;
        this.queue = new LinkedBlockingQueue(queueSize);
        this.queueLock = new Object();
        ProtocolChecksKt.checkProtocol(this.protocol);
        if (buildInitial) {
            this.queue.add(this.makeClient());
        }
    }

    @Override
    public <R> R borrow(@NotNull Function1<? super IClient<T>, ? extends R> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        return IClientPool.DefaultImpls.borrow(this, block);
    }

    @Override
    @Nullable
    public <R> R tryBorrow(@NotNull Function1<? super IClient<T>, ? extends R> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        return IClientPool.DefaultImpls.tryBorrow(this, block);
    }

    @Override
    @NotNull
    public DataPipe call(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return IClientPool.DefaultImpls.call(this, key);
    }

    @Override
    public <R> R call(@NotNull String key, @NotNull Function1<? super DataPipe, ? extends R> block) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        return IClientPool.DefaultImpls.call(this, key, block);
    }

    @Override
    @NotNull
    public DataPipe extension(byte code) {
        return IClientPool.DefaultImpls.extension(this, code);
    }

    @Override
    public <R> R extension(byte code, @NotNull Function1<? super DataPipe, ? extends R> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        return IClientPool.DefaultImpls.extension(this, code, block);
    }

    @Override
    @NotNull
    public List<String> getCommandList() {
        return IClientPool.DefaultImpls.getCommandList(this);
    }

    @Override
    @NotNull
    public List<Byte> getExtensionCodes() {
        return IClientPool.DefaultImpls.getExtensionCodes(this);
    }

    public static final /* synthetic */ void access$setClosed$p(ClientPoolImpl $this, boolean bl) {
        $this.closed = bl;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0001\u00a2\u0006\u0002\u0010\u0003J\u0011\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\bH\u0096\u0001J0\u0010 \u001a\u0002H\"\"\u0004\b\u0001\u0010\"2\u0006\u0010!\u001a\u00020\b2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u0002H\"0$H\u0096\u0001\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020'H\u0016J\u0011\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u000fH\u0096\u0001J0\u0010(\u001a\u0002H\"\"\u0004\b\u0001\u0010\"2\u0006\u0010)\u001a\u00020\u000f2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u0002H\"0$H\u0096\u0001\u00a2\u0006\u0002\u0010*R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00028\u0000X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u0012\u0010\u0011\u001a\u00020\u0012X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0012X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R\u0012\u0010\u0015\u001a\u00020\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00020\u001dX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006+"}, d2={"Lpw/aru/utils/ipc/client/impl/ClientPoolImpl$PoolClient;", "Lpw/aru/utils/ipc/client/IClient;", "client", "(Lpw/aru/utils/ipc/client/impl/ClientPoolImpl;Lpw/aru/utils/ipc/client/IClient;)V", "getClient", "()Lpw/aru/utils/ipc/client/IClient;", "commandList", "", "", "getCommandList", "()Ljava/util/List;", "connector", "getConnector", "()Ljava/lang/Object;", "extensionCodes", "", "getExtensionCodes", "isAlive", "", "()Z", "isIdle", "pipe", "Lpw/aru/utils/io/DataPipe;", "getPipe", "()Lpw/aru/utils/io/DataPipe;", "serverName", "getServerName", "()Ljava/lang/String;", "state", "Lpw/aru/utils/ipc/proto/ConnectionState;", "getState", "()Lpw/aru/utils/ipc/proto/ConnectionState;", "call", "key", "R", "block", "Lkotlin/Function1;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "close", "", "extension", "code", "(BLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "simple-ipc"})
    private final class PoolClient
    implements IClient<T> {
        @NotNull
        private final IClient<T> client;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (ClientPoolImpl.this.closed) {
                try {
                    this.client.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            if (!this.isAlive() || !this.isIdle()) {
                try {
                    this.client.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            if (!ClientPoolImpl.this.queue.offer(this)) {
                try {
                    this.client.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            Object object = ClientPoolImpl.this.queueLock;
            synchronized (object) {
                int lastMaxCreated = ClientPoolImpl.this.maxCreated;
                if (ClientPoolImpl.this.getAvailable() > lastMaxCreated + 2) {
                    ClientPoolImpl.this.maxCreated = 0;
                    ClientPoolImpl.this.launchCleanup(lastMaxCreated);
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        @NotNull
        public final IClient<T> getClient() {
            return this.client;
        }

        public PoolClient(IClient<T> client) {
            Intrinsics.checkParameterIsNotNull(client, (String)"client");
            this.client = client;
        }

        @Override
        @NotNull
        public List<String> getCommandList() {
            return this.client.getCommandList();
        }

        @Override
        public T getConnector() {
            return this.client.getConnector();
        }

        @Override
        @NotNull
        public List<Byte> getExtensionCodes() {
            return this.client.getExtensionCodes();
        }

        @Override
        public boolean isAlive() {
            return this.client.isAlive();
        }

        @Override
        public boolean isIdle() {
            return this.client.isIdle();
        }

        @Override
        @NotNull
        public DataPipe getPipe() {
            return this.client.getPipe();
        }

        @Override
        @NotNull
        public String getServerName() {
            return this.client.getServerName();
        }

        @Override
        @NotNull
        public ConnectionState getState() {
            return this.client.getState();
        }

        @Override
        @NotNull
        public DataPipe call(@NotNull String key) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            return this.client.call(key);
        }

        @Override
        public <R> R call(@NotNull String key, @NotNull Function1<? super DataPipe, ? extends R> block) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull(block, (String)"block");
            return this.client.call(key, block);
        }

        @Override
        @NotNull
        public DataPipe extension(byte code) {
            return this.client.extension(code);
        }

        @Override
        public <R> R extension(byte code, @NotNull Function1<? super DataPipe, ? extends R> block) {
            Intrinsics.checkParameterIsNotNull(block, (String)"block");
            return this.client.extension(code, block);
        }
    }
}

