/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.utils.ipc.client;

import java.io.Closeable;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import pw.aru.utils.io.DataPipe;
import pw.aru.utils.io.DataPipeStream;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 (2\u00020\u0001:\u0001(B\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000bJ\b\u0010#\u001a\u00020$H\u0016J\u000e\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020\u000fJ\b\u0010'\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lpw/aru/utils/ipc/client/IPCClient;", "Ljava/io/Closeable;", "address", "Ljava/net/InetAddress;", "port", "", "(Ljava/net/InetAddress;I)V", "getAddress", "()Ljava/net/InetAddress;", "commandList", "", "", "getCommandList", "()Ljava/util/List;", "extensionCodes", "", "getExtensionCodes", "io", "Lpw/aru/utils/io/DataPipeStream;", "getIo", "()Lpw/aru/utils/io/DataPipeStream;", "isAlive", "", "()Z", "isValid", "getPort", "()I", "serverName", "getServerName", "()Ljava/lang/String;", "socket", "Ljava/net/Socket;", "call", "Lpw/aru/utils/io/DataPipe;", "key", "close", "", "extension", "code", "toString", "Companion", "simple-ipc"})
public final class IPCClient
implements Closeable {
    private final Socket socket;
    @NotNull
    private final DataPipeStream io;
    @NotNull
    private final String serverName;
    @NotNull
    private final InetAddress address;
    private final int port;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final DataPipeStream getIo() {
        return this.io;
    }

    @NotNull
    public final String getServerName() {
        return this.serverName;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DataPipe call(@NotNull String key) {
        void value$iv;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Companion companion = Companion;
        boolean bl = this.io.write(4).readUnsignedByte() == 2;
        String step$iv = "OP call answer code";
        if (value$iv == false) {
            throw (Throwable)new IllegalStateException("Protocol infringed by server on step: " + step$iv);
        }
        int op = this.io.writeString(key).readUnsignedByte();
        boolean bl2 = bl = op == 1;
        if (!bl) {
            switch (op) {
                case -2: {
                    throw (Throwable)new IllegalArgumentException("Unknown call '" + key + '\'');
                }
            }
            String string = "Protocol infringed by server on step: OP call answer code";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return (DataPipe)this.io;
    }

    @NotNull
    public final DataPipe extension(byte code) {
        boolean bl;
        int op = this.io.write((int)code).readUnsignedByte();
        boolean bl2 = bl = op == 3;
        if (!bl) {
            switch (op) {
                case -1: {
                    IllegalArgumentException illegalArgumentException;
                    byte by = code;
                    int n = 16;
                    StringBuilder stringBuilder = new StringBuilder().append("Invalid extension code '");
                    IllegalArgumentException illegalArgumentException2 = illegalArgumentException;
                    IllegalArgumentException illegalArgumentException3 = illegalArgumentException;
                    byte by2 = by;
                    int n2 = CharsKt.checkRadix((int)n);
                    String string = Integer.toString(by2, CharsKt.checkRadix((int)n2));
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
                    String string2 = string;
                    illegalArgumentException2(stringBuilder.append(string2).append('\'').toString());
                    throw (Throwable)illegalArgumentException3;
                }
            }
            String string = "Protocol infringed by server on step: OP call answer code";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return (DataPipe)this.io;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getCommandList() {
        void var3_4;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        void value$iv22;
        Companion companion = Companion;
        boolean bl = this.io.write(2).readUnsignedByte() == 1;
        String step$iv = "OP call answer code";
        if (value$iv22 == false) {
            throw (Throwable)new IllegalStateException("Protocol infringed by server on step: " + step$iv);
        }
        Iterable value$iv22 = $receiver$iv = (Iterable)RangesKt.until((int)0, (int)this.io.readInt());
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            String string = this.io.readString();
            collection.add(string);
        }
        return (List)var3_4;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Byte> getExtensionCodes() {
        void var3_4;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        void value$iv22;
        Companion companion = Companion;
        boolean bl = this.io.write(3).readUnsignedByte() == 1;
        String step$iv = "OP call answer code";
        if (value$iv22 == false) {
            throw (Throwable)new IllegalStateException("Protocol infringed by server on step: " + step$iv);
        }
        Iterable value$iv22 = $receiver$iv = (Iterable)RangesKt.until((int)0, (int)this.io.readInt());
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            Byte by = this.io.readByte();
            collection.add(by);
        }
        return (List)var3_4;
    }

    public final boolean isAlive() {
        return !this.socket.isClosed();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isValid() {
        boolean bl;
        if (!this.isAlive()) {
            return false;
        }
        try {
            this.io.write(1);
            boolean available = false;
            int n = 0;
            int n2 = 2;
            while (n <= n2) {
                void i;
                boolean bl2 = available = this.io.getInputStream().available() >= 4;
                if (available) break;
                Thread.sleep(50L);
                ++i;
            }
            bl = available && this.io.write(1).readInt() == 134269694 && Intrinsics.areEqual((Object)this.io.readString(), (Object)this.serverName) && this.io.readUnsignedShort() == 57005;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void close() {
        if (this.isAlive()) {
            this.io.write(0);
            this.socket.close();
        }
    }

    @NotNull
    public String toString() {
        return "IPCClient[address=" + this.address + ",port=" + this.port + ",serverName=" + this.serverName + ']';
    }

    @NotNull
    public final InetAddress getAddress() {
        return this.address;
    }

    public final int getPort() {
        return this.port;
    }

    public IPCClient(@NotNull InetAddress address, int port) {
        boolean value$iv;
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        this.address = address;
        this.port = port;
        this.socket = new Socket(this.address, this.port);
        this.io = new DataPipeStream(this.socket.getInputStream(), this.socket.getOutputStream());
        Companion companion = Companion;
        boolean bl = this.io.readInt() == 134269694;
        String step$iv = "Server Handshake";
        if (!value$iv) {
            throw (Throwable)new IllegalStateException("Protocol infringed by server on step: " + step$iv);
        }
        String string = this.io.readString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"io.readString()");
        this.serverName = string;
        Companion this_$iv = Companion;
        value$iv = this.io.readUnsignedShort() == 57005;
        step$iv = "Server ACK Code";
        if (!value$iv) {
            throw (Throwable)new IllegalStateException("Protocol infringed by server on step: " + step$iv);
        }
        this.io.writeBoolean(true);
        this_$iv = Companion;
        value$iv = this.io.readUnsignedByte() == 1;
        step$iv = "Client ACK by Server";
        if (!value$iv) {
            throw (Throwable)new IllegalStateException("Protocol infringed by server on step: " + step$iv);
        }
    }

    public /* synthetic */ IPCClient(InetAddress inetAddress, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            InetAddress inetAddress2 = InetAddress.getLocalHost();
            Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress2, (String)"getLocalHost()");
            inetAddress = inetAddress2;
        }
        this(inetAddress, n);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0082\b\u00a8\u0006\t"}, d2={"Lpw/aru/utils/ipc/client/IPCClient$Companion;", "", "()V", "check", "", "value", "", "step", "", "simple-ipc"})
    public static final class Companion {
        private final void check(boolean value, String step) {
            if (!value) {
                throw (Throwable)new IllegalStateException("Protocol infringed by server on step: " + step);
            }
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$check(Companion $this, boolean value, @NotNull String step) {
            $this.check(value, step);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

