/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Properties
extends ConcurrentHashMap<String, String> {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    @NotNull
    public static Properties fromFile(@NotNull File file) throws IOException {
        Properties p = new Properties();
        p.load(new FileInputStream(file));
        return p;
    }

    @NotNull
    public static Properties fromFile(@NotNull String file) throws IOException {
        return Properties.fromFile(new File(file));
    }

    @NotNull
    public static Properties fromString(@NotNull String string) throws IOException {
        Properties p = new Properties();
        p.loadFromString(string);
        return p;
    }

    public synchronized void load(@NotNull Reader reader) throws IOException {
        this._load(new LineReader(reader));
    }

    public synchronized void load(@NotNull InputStream inStream) throws IOException {
        this._load(new LineReader(inStream));
    }

    public synchronized void loadFromString(@NotNull String string) throws IOException {
        this._load(new LineReader(new StringReader(string)));
    }

    public synchronized void store(@NotNull OutputStream out, @Nullable String comments) throws IOException {
        this._store(new BufferedWriter(new OutputStreamWriter(out, "8859_1")), comments, true);
    }

    public synchronized void store(@NotNull Writer writer, @Nullable String comments) throws IOException {
        this._store(writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer), comments, false);
    }

    public synchronized void store(@NotNull File file, @Nullable String comments) throws IOException {
        this._store(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "8859_1")), comments, true);
    }

    @NotNull
    public synchronized String storeToString(@Nullable String comments) throws IOException {
        StringWriter w = new StringWriter();
        this._store(new BufferedWriter(w), comments, false);
        return w.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    private static void writeComments(BufferedWriter bw, String comments) throws IOException {
        int current;
        bw.write("#");
        char[] in = comments.toCharArray();
        int len = comments.length();
        int last = 0;
        char[] uu = new char[6];
        uu[0] = 92;
        uu[1] = 117;
        for (current = 0; current < len; ++current) {
            char c = in[current];
            if (c <= '\u00ff' && c != '\n' && c != '\r') continue;
            if (last != current) {
                bw.write(comments.substring(last, current));
            }
            if (c > '\u00ff') {
                uu[2] = Properties.toHex(c >> 12 & 0xF);
                uu[3] = Properties.toHex(c >> 8 & 0xF);
                uu[4] = Properties.toHex(c >> 4 & 0xF);
                uu[5] = Properties.toHex(c & 0xF);
                bw.write(new String(uu));
            } else {
                bw.newLine();
                if (c == '\r' && current != len - 1 && in[current + 1] == '\n') {
                    ++current;
                }
                if (current == len - 1 || in[current + 1] != '#' && in[current + 1] != '!') {
                    bw.write("#");
                }
            }
            last = current + 1;
        }
        if (last != current) {
            bw.write(comments.substring(last, current));
        }
        bw.newLine();
    }

    private void _load(LineReader lr) throws IOException {
        int limit;
        char[] convtBuf = new char[1024];
        while ((limit = lr.readLine()) >= 0) {
            char c;
            int keyLen;
            int valueStart = limit;
            boolean hasSep = false;
            boolean precedingBackslash = false;
            for (keyLen = 0; keyLen < limit; ++keyLen) {
                c = lr.lineBuf[keyLen];
                if (!(c != '=' && c != ':' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    hasSep = true;
                    break;
                }
                if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    break;
                }
                precedingBackslash = c == '\\' && !precedingBackslash;
            }
            while (valueStart < limit) {
                c = lr.lineBuf[valueStart];
                if (c != ' ' && c != '\t' && c != '\f') {
                    if (hasSep || c != '=' && c != ':') break;
                    hasSep = true;
                }
                ++valueStart;
            }
            this.put(this.loadConvert(lr.lineBuf, 0, keyLen, convtBuf), this.loadConvert(lr.lineBuf, valueStart, limit - valueStart, convtBuf));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _store(BufferedWriter bw, String comments, boolean escUnicode) throws IOException {
        if (comments != null) {
            Properties.writeComments(bw, comments);
        }
        bw.write("#" + new Date().toString());
        bw.newLine();
        Properties properties = this;
        synchronized (properties) {
            for (Map.Entry entry : this.entrySet()) {
                bw.write(this.saveConvert((String)entry.getKey(), true, escUnicode) + "=" + this.saveConvert((String)entry.getValue(), false, escUnicode));
                bw.newLine();
            }
        }
        bw.flush();
    }

    private String loadConvert(char[] in, int off, int len, char[] convtBuf) {
        char[] out = convtBuf.length < len ? new char[len * 2] : convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int c;
            if ((c = in[off++]) == 92) {
                if ((c = in[off++]) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        c = in[off++];
                        switch (c) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + c - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + c - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + c - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                c = c == 116 ? 9 : (c == 114 ? 13 : (c == 110 ? 10 : (c == 102 ? 12 : c)));
                out[outLen++] = c;
                continue;
            }
            out[outLen++] = c;
        }
        return new String(out, 0, outLen);
    }

    private String saveConvert(String s, boolean escapeSpace, boolean escapeUnicode) {
        char[] in = s.toCharArray();
        int len = in.length;
        StringBuilder b = new StringBuilder(len * 2);
        block8: for (int i = 0; i < len; ++i) {
            char c = in[i];
            if (c > '=' && c < '\u007f') {
                if (c == '\\') {
                    b.append('\\').append('\\');
                    continue;
                }
                b.append(c);
                continue;
            }
            switch (c) {
                case ' ': {
                    if (i == 0 || escapeSpace) {
                        b.append('\\');
                    }
                    b.append(' ');
                    continue block8;
                }
                case '\t': {
                    b.append('\\').append('t');
                    continue block8;
                }
                case '\n': {
                    b.append('\\').append('n');
                    continue block8;
                }
                case '\r': {
                    b.append('\\').append('r');
                    continue block8;
                }
                case '\f': {
                    b.append('\\').append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    b.append('\\').append(c);
                    continue block8;
                }
                default: {
                    if ((c < ' ' || c > '~') & escapeUnicode) {
                        b.append('\\').append('u').append(Properties.toHex(c >> 12 & 0xF)).append(Properties.toHex(c >> 8 & 0xF)).append(Properties.toHex(c >> 4 & 0xF)).append(Properties.toHex(c & 0xF));
                        continue block8;
                    }
                    b.append(c);
                }
            }
        }
        return b.toString();
    }

    private class LineReader {
        byte[] inByteBuf;
        char[] inCharBuf;
        int inLimit = 0;
        int inOff = 0;
        InputStream inStream;
        char[] lineBuf = new char[1024];
        Reader reader;

        LineReader(InputStream inStream) {
            this.inStream = inStream;
            this.inByteBuf = new byte[8192];
        }

        LineReader(Reader reader) {
            this.reader = reader;
            this.inCharBuf = new char[8192];
        }

        int readLine() throws IOException {
            int len = 0;
            boolean skipWhiteSpace = true;
            boolean isCommentLine = false;
            boolean isNewLine = true;
            boolean appendedLineBegin = false;
            boolean precedingBackslash = false;
            boolean skipLF = false;
            while (true) {
                char c;
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (len == 0 || isCommentLine) {
                            return -1;
                        }
                        if (precedingBackslash) {
                            --len;
                        }
                        return len;
                    }
                }
                char c2 = c = this.inStream != null ? (char)(0xFF & this.inByteBuf[this.inOff++]) : this.inCharBuf[this.inOff++];
                if (skipLF) {
                    skipLF = false;
                    if (c == '\n') continue;
                }
                if (skipWhiteSpace) {
                    if (c == ' ' || c == '\t' || c == '\f' || !appendedLineBegin && (c == '\r' || c == '\n')) continue;
                    skipWhiteSpace = false;
                    appendedLineBegin = false;
                }
                if (isNewLine) {
                    isNewLine = false;
                    if (c == '#' || c == '!') {
                        isCommentLine = true;
                        continue;
                    }
                }
                if (c != '\n' && c != '\r') {
                    this.lineBuf[len++] = c;
                    if (len == this.lineBuf.length) {
                        int newLength = this.lineBuf.length * 2;
                        if (newLength < 0) {
                            newLength = Integer.MAX_VALUE;
                        }
                        char[] buf = new char[newLength];
                        System.arraycopy(this.lineBuf, 0, buf, 0, this.lineBuf.length);
                        this.lineBuf = buf;
                    }
                    precedingBackslash = c == '\\' && !precedingBackslash;
                    continue;
                }
                if (isCommentLine || len == 0) {
                    isCommentLine = false;
                    isNewLine = true;
                    skipWhiteSpace = true;
                    len = 0;
                    continue;
                }
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (precedingBackslash) {
                            --len;
                        }
                        return len;
                    }
                }
                if (!precedingBackslash) break;
                --len;
                skipWhiteSpace = true;
                appendedLineBegin = true;
                precedingBackslash = false;
                if (c != '\r') continue;
                skipLF = true;
            }
            return len;
        }
    }
}

