/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.utils.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public interface DataPipe
extends Closeable {
    @NotNull
    public InputStream getInputStream();

    @NotNull
    public OutputStream getOutputStream();

    @NotNull
    public DataPipe flush() throws IOException;

    public int skipBytes(int var1) throws IOException;

    @Override
    public void close() throws IOException;

    public boolean readBoolean() throws IOException;

    public byte readByte() throws IOException;

    public char readChar() throws IOException;

    public double readDouble() throws IOException;

    public float readFloat() throws IOException;

    @NotNull
    public DataPipe readFully(@NotNull byte[] var1) throws IOException;

    @NotNull
    public DataPipe readFully(@NotNull byte[] var1, int var2, int var3) throws IOException;

    public int readInt() throws IOException;

    public long readLong() throws IOException;

    public short readShort() throws IOException;

    @NotNull
    public String readString() throws IOException;

    public int readUnsignedByte() throws IOException;

    public int readUnsignedShort() throws IOException;

    @NotNull
    public DataPipe writeBoolean(boolean var1) throws IOException;

    @NotNull
    public DataPipe writeByte(int var1) throws IOException;

    @NotNull
    public DataPipe writeBytes(@NotNull byte[] var1) throws IOException;

    @NotNull
    public DataPipe writeBytes(@NotNull byte[] var1, int var2, int var3) throws IOException;

    @NotNull
    public DataPipe writeBytes(@NotNull String var1) throws IOException;

    @NotNull
    public DataPipe writeChar(int var1) throws IOException;

    @NotNull
    public DataPipe writeChars(@NotNull CharSequence var1) throws IOException;

    @NotNull
    public DataPipe writeDouble(double var1) throws IOException;

    @NotNull
    public DataPipe writeFloat(float var1) throws IOException;

    @NotNull
    public DataPipe writeInt(int var1) throws IOException;

    @NotNull
    public DataPipe writeLong(long var1) throws IOException;

    @NotNull
    public DataPipe writeShort(int var1) throws IOException;

    @NotNull
    public DataPipe writeString(@NotNull String var1) throws IOException;

    default public byte read() throws IOException {
        return this.readByte();
    }

    @NotNull
    default public DataPipe write(int v) throws IOException {
        return this.writeByte(v);
    }

    @NotNull
    default public boolean[] readBooleanArray(int length) throws IOException {
        boolean[] array = new boolean[length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readBoolean();
        }
        return array;
    }

    @NotNull
    default public byte[] readByteArray(int length) throws IOException {
        byte[] array = new byte[length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readByte();
        }
        return array;
    }

    @NotNull
    default public char[] readCharArray(int length) throws IOException {
        char[] array = new char[length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readChar();
        }
        return array;
    }

    @NotNull
    default public double[] readDoubleArray(int length) throws IOException {
        double[] array = new double[length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readDouble();
        }
        return array;
    }

    @NotNull
    default public float[] readFloatArray(int length) throws IOException {
        float[] array = new float[length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readFloat();
        }
        return array;
    }

    @NotNull
    default public int[] readIntArray(int length) throws IOException {
        int[] array = new int[length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readInt();
        }
        return array;
    }

    @NotNull
    default public long[] readLongArray(int length) throws IOException {
        long[] array = new long[length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readLong();
        }
        return array;
    }

    @NotNull
    default public short[] readShortArray(int length) throws IOException {
        short[] array = new short[length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readShort();
        }
        return array;
    }

    @NotNull
    default public DataPipe writeBooleanArray(@NotNull boolean[] array) throws IOException {
        for (boolean v : array) {
            this.writeBoolean(v);
        }
        return this;
    }

    @NotNull
    default public DataPipe writeByteArray(@NotNull byte[] array) throws IOException {
        for (byte v : array) {
            this.writeByte(v);
        }
        return this;
    }

    @NotNull
    default public DataPipe writeCharArray(@NotNull char[] array) throws IOException {
        for (char v : array) {
            this.writeChar(v);
        }
        return this;
    }

    @NotNull
    default public DataPipe writeDoubleArray(@NotNull double[] array) throws IOException {
        for (double v : array) {
            this.writeDouble(v);
        }
        return this;
    }

    @NotNull
    default public DataPipe writeFloatArray(@NotNull float[] array) throws IOException {
        for (float v : array) {
            this.writeFloat(v);
        }
        return this;
    }

    @NotNull
    default public DataPipe writeIntArray(@NotNull int[] array) throws IOException {
        for (int v : array) {
            this.writeInt(v);
        }
        return this;
    }

    @NotNull
    default public DataPipe writeLongArray(@NotNull long[] array) throws IOException {
        for (long v : array) {
            this.writeLong(v);
        }
        return this;
    }

    @NotNull
    default public DataPipe writeShortArray(@NotNull short[] array) throws IOException {
        for (short v : array) {
            this.writeShort(v);
        }
        return this;
    }

    @NotNull
    default public DataPipe writeStringArray(@NotNull String[] array) throws IOException {
        for (String v : array) {
            this.writeString(v);
        }
        return this;
    }

    default public boolean[] readSizedBooleanArray() throws IOException {
        return this.readBooleanArray(this.readInt());
    }

    default public byte[] readSizedByteArray() throws IOException {
        return this.readByteArray(this.readInt());
    }

    default public char[] readSizedCharArray() throws IOException {
        return this.readCharArray(this.readInt());
    }

    default public double[] readSizedDoubleArray() throws IOException {
        return this.readDoubleArray(this.readInt());
    }

    default public float[] readSizedFloatArray() throws IOException {
        return this.readFloatArray(this.readInt());
    }

    default public int[] readSizedIntArray() throws IOException {
        return this.readIntArray(this.readInt());
    }

    default public long[] readSizedLongArray() throws IOException {
        return this.readLongArray(this.readInt());
    }

    default public short[] readSizedShortArray() throws IOException {
        return this.readShortArray(this.readInt());
    }

    @NotNull
    default public DataPipe writeSizedBooleanArray(@NotNull boolean[] array) throws IOException {
        return this.writeInt(array.length).writeBooleanArray(array);
    }

    @NotNull
    default public DataPipe writeSizedByteArray(@NotNull byte[] array) throws IOException {
        return this.writeInt(array.length).writeByteArray(array);
    }

    @NotNull
    default public DataPipe writeSizedCharArray(@NotNull char[] array) throws IOException {
        return this.writeInt(array.length).writeCharArray(array);
    }

    @NotNull
    default public DataPipe writeSizedDoubleArray(@NotNull double[] array) throws IOException {
        return this.writeInt(array.length).writeDoubleArray(array);
    }

    @NotNull
    default public DataPipe writeSizedFloatArray(@NotNull float[] array) throws IOException {
        return this.writeInt(array.length).writeFloatArray(array);
    }

    @NotNull
    default public DataPipe writeSizedIntArray(@NotNull int[] array) throws IOException {
        return this.writeInt(array.length).writeIntArray(array);
    }

    @NotNull
    default public DataPipe writeSizedLongArray(@NotNull long[] array) throws IOException {
        return this.writeInt(array.length).writeLongArray(array);
    }

    @NotNull
    default public DataPipe writeSizedShortArray(@NotNull short[] array) throws IOException {
        return this.writeInt(array.length).writeShortArray(array);
    }

    @NotNull
    default public DataPipe writeSizedStringArray(@NotNull String[] array) throws IOException {
        return this.writeInt(array.length).writeStringArray(array);
    }
}

