/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.utils.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import org.jetbrains.annotations.NotNull;
import pw.aru.utils.io.DataPipe;

public class DataPipeStream
implements DataPipe {
    private final InputStream in;
    private final OutputStream out;
    private byte[] bytearr = new byte[80];
    private char[] chararr = new char[80];
    private byte[] readBuffer = new byte[8];
    private byte[] writeBuffer = new byte[8];

    public DataPipeStream(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
    }

    @Override
    @NotNull
    public DataPipe flush() throws IOException {
        this.out.flush();
        return this;
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public final boolean readBoolean() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public final char readChar() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + ch2);
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    @NotNull
    public final DataPipe readFully(@NotNull byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
        return this;
    }

    @Override
    @NotNull
    public final DataPipe readFully(@NotNull byte[] b, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.in.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
        return this;
    }

    @Override
    public final int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read()) | (ch3 = this.in.read()) | (ch4 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    @Override
    public final long readLong() throws IOException {
        this.readFully(this.readBuffer, 0, 8);
        return ((long)this.readBuffer[0] << 56) + ((long)(this.readBuffer[1] & 0xFF) << 48) + ((long)(this.readBuffer[2] & 0xFF) << 40) + ((long)(this.readBuffer[3] & 0xFF) << 32) + ((long)(this.readBuffer[4] & 0xFF) << 24) + (long)((this.readBuffer[5] & 0xFF) << 16) + (long)((this.readBuffer[6] & 0xFF) << 8) + (long)(this.readBuffer[7] & 0xFF);
    }

    @Override
    public final short readShort() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + ch2);
    }

    @Override
    @NotNull
    public final String readString() throws IOException {
        return this._readString();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + ch2;
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        int total;
        int cur;
        for (total = 0; total < n && (cur = (int)this.in.skip(n - total)) > 0; total += cur) {
        }
        return total;
    }

    @Override
    @NotNull
    public final DataPipeStream writeBoolean(boolean v) throws IOException {
        this.out.write(v ? 1 : 0);
        return this;
    }

    @Override
    @NotNull
    public final DataPipeStream writeByte(int v) throws IOException {
        this.out.write(v);
        return this;
    }

    @Override
    @NotNull
    public DataPipe writeBytes(@NotNull byte[] b) throws IOException {
        this.out.write(b);
        return this;
    }

    @Override
    @NotNull
    public synchronized DataPipeStream writeBytes(@NotNull byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        return this;
    }

    @Override
    @NotNull
    public final DataPipeStream writeBytes(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.out.write((byte)s.charAt(i));
        }
        return this;
    }

    @Override
    @NotNull
    public final DataPipeStream writeChar(int v) throws IOException {
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v & 0xFF);
        return this;
    }

    @Override
    @NotNull
    public final DataPipeStream writeChars(CharSequence s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.out.write(v >>> 8 & 0xFF);
            this.out.write(v & 0xFF);
        }
        return this;
    }

    @Override
    @NotNull
    public final DataPipeStream writeDouble(double v) throws IOException {
        return this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    @NotNull
    public final DataPipeStream writeFloat(float v) throws IOException {
        return this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    @NotNull
    public final DataPipeStream writeInt(int v) throws IOException {
        this.out.write(v >>> 24 & 0xFF);
        this.out.write(v >>> 16 & 0xFF);
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v & 0xFF);
        return this;
    }

    @Override
    @NotNull
    public final DataPipeStream writeLong(long v) throws IOException {
        this.writeBuffer[0] = (byte)(v >>> 56);
        this.writeBuffer[1] = (byte)(v >>> 48);
        this.writeBuffer[2] = (byte)(v >>> 40);
        this.writeBuffer[3] = (byte)(v >>> 32);
        this.writeBuffer[4] = (byte)(v >>> 24);
        this.writeBuffer[5] = (byte)(v >>> 16);
        this.writeBuffer[6] = (byte)(v >>> 8);
        this.writeBuffer[7] = (byte)v;
        this.out.write(this.writeBuffer, 0, 8);
        return this;
    }

    @Override
    @NotNull
    public final DataPipeStream writeShort(int v) throws IOException {
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v & 0xFF);
        return this;
    }

    @Override
    @NotNull
    public final DataPipeStream writeString(@NotNull String str) throws IOException {
        this._writeString(str);
        return this;
    }

    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            this.out.close();
        }
    }

    private String _readString() throws IOException {
        int c;
        int count;
        int utflen = this.readUnsignedShort();
        if (this.bytearr.length < utflen) {
            this.bytearr = new byte[utflen * 2];
            this.chararr = new char[utflen * 2];
        }
        int chararr_count = 0;
        this.readFully(this.bytearr, 0, utflen);
        for (count = 0; count < utflen && (c = this.bytearr[count] & 0xFF) <= 127; ++count) {
            this.chararr[chararr_count++] = (char)c;
        }
        block6: while (count < utflen) {
            c = this.bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    this.chararr[chararr_count++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed : partial character at end");
                    }
                    byte char2 = this.bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed  around byte " + count);
                    }
                    this.chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed : partial character at end");
                    }
                    byte char2 = this.bytearr[count - 2];
                    byte char3 = this.bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed  around byte " + (count - 1));
                    }
                    this.chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed  around byte " + count);
        }
        return new String(this.chararr, 0, chararr_count);
    }

    private void _writeString(String str) throws IOException {
        int i;
        char c;
        int strlen = str.length();
        int utflen = 0;
        int count = 0;
        for (int i2 = 0; i2 < strlen; ++i2) {
            c = str.charAt(i2);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + utflen + " bytes");
        }
        byte[] bytearr = new byte[utflen + 2];
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen & 0xFF);
        for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c & 0x3F);
            }
            ++i;
        }
        this.writeBytes(bytearr, 0, utflen + 2);
    }
}

