/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.utils.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public interface DataPipe
extends Closeable {
    @NotNull
    public DataPipe flush() throws IOException;

    @NotNull
    public InputStream getInputStream();

    @NotNull
    public OutputStream getOutputStream();

    public boolean readBoolean() throws IOException;

    public byte readByte() throws IOException;

    public char readChar() throws IOException;

    public double readDouble() throws IOException;

    public float readFloat() throws IOException;

    @NotNull
    public DataPipe readFully(@NotNull byte[] var1) throws IOException;

    @NotNull
    public DataPipe readFully(@NotNull byte[] var1, int var2, int var3) throws IOException;

    public int readInt() throws IOException;

    public long readLong() throws IOException;

    public short readShort() throws IOException;

    @NotNull
    public String readString() throws IOException;

    public int readUnsignedByte() throws IOException;

    public int readUnsignedShort() throws IOException;

    public int skipBytes(int var1) throws IOException;

    @NotNull
    public DataPipe writeBoolean(boolean var1) throws IOException;

    @NotNull
    public DataPipe writeByte(int var1) throws IOException;

    @NotNull
    public DataPipe writeBytes(@NotNull byte[] var1) throws IOException;

    @NotNull
    public DataPipe writeBytes(@NotNull byte[] var1, int var2, int var3) throws IOException;

    @NotNull
    public DataPipe writeBytes(@NotNull String var1) throws IOException;

    @NotNull
    public DataPipe writeChar(int var1) throws IOException;

    @NotNull
    public DataPipe writeChars(@NotNull String var1) throws IOException;

    @NotNull
    public DataPipe writeDouble(double var1) throws IOException;

    @NotNull
    public DataPipe writeFloat(float var1) throws IOException;

    @NotNull
    public DataPipe writeInt(int var1) throws IOException;

    @NotNull
    public DataPipe writeLong(long var1) throws IOException;

    @NotNull
    public DataPipe writeShort(int var1) throws IOException;

    @NotNull
    public DataPipe writeString(@NotNull String var1) throws IOException;

    @Override
    public void close() throws IOException;

    default public byte read() throws IOException {
        return this.readByte();
    }

    @NotNull
    default public DataPipe write(int v) throws IOException {
        return this.writeByte(v);
    }
}

