/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.redditstream;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.json.JSONObject;
import pw.aru.libs.redditstream.RedditStream;

public class Subreddit {
    private final RedditStream redditStream;
    private String name;
    private String title;
    private String description;
    private boolean nsfw;
    private boolean quarantine;
    private int subscribers;
    private long createdAt;

    public Subreddit(RedditStream redditStream, String name) {
        this.redditStream = redditStream;
        this.name = name;
        this.update();
    }

    public Subreddit(RedditStream redditStream, String name, String title, String description, boolean nsfw, boolean quarantine, int subscribers, long createdAt) {
        this.redditStream = redditStream;
        this.name = name;
        this.title = title;
        this.description = description;
        this.nsfw = nsfw;
        this.quarantine = quarantine;
        this.subscribers = subscribers;
        this.createdAt = createdAt;
    }

    public Subreddit update() {
        try {
            String body = this.redditStream.client.send(HttpRequest.newBuilder().uri(URI.create("https://www.reddit.com/r/" + this.name + "/about.json")).header("User-Agent", RedditStream.USER_AGENT).build(), HttpResponse.BodyHandlers.ofString()).body();
            JSONObject json = new JSONObject(body).getJSONObject("data");
            this.name = json.getString("display_name");
            this.title = json.getString("title");
            this.description = json.getString("public_description");
            this.nsfw = json.getBoolean("over_18");
            this.quarantine = json.getBoolean("quarantine");
            this.subscribers = json.getInt("subscribers");
            this.createdAt = json.getLong("created");
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Operation was interrupted.", e);
        }
        catch (IOException e) {
            throw new UncheckedIOException("A IO exception ocurred while updating the object.", e);
        }
        return this;
    }

    public RedditStream getRedditStream() {
        return this.redditStream;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isNsfw() {
        return this.nsfw;
    }

    public boolean isQuarantine() {
        return this.quarantine;
    }

    public int getSubscribers() {
        return this.subscribers;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }
}

