/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.redditstream;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.json.JSONArray;
import org.json.JSONObject;
import pw.aru.libs.redditstream.RedditStream;
import pw.aru.libs.redditstream.Subreddit;

public class Post {
    private final RedditStream redditStream;
    private Subreddit subreddit;
    private String author;
    private String title;
    private String selfText;
    private String link;
    private String permalink;
    private boolean spoiler;
    private boolean nsfw;
    private boolean quarantine;
    private int score;
    private int upvotes;
    private int downvotes;
    private long createdAt;

    public Post(RedditStream redditStream, String permalink) {
        this.redditStream = redditStream;
        this.permalink = permalink;
        this.update();
    }

    public Post(RedditStream redditStream, Subreddit subreddit, String author, String title, String selfText, String link, String permalink, int score, int upvotes, int downvotes, boolean spoiler, boolean nsfw, boolean quarantine, long createdAt) {
        this.redditStream = redditStream;
        this.subreddit = subreddit;
        this.author = author;
        this.title = title;
        this.selfText = selfText;
        this.link = link;
        this.permalink = permalink;
        this.score = score;
        this.upvotes = upvotes;
        this.downvotes = downvotes;
        this.spoiler = spoiler;
        this.nsfw = nsfw;
        this.quarantine = quarantine;
        this.createdAt = createdAt;
    }

    public Post update() {
        try {
            String body = this.redditStream.client.send(HttpRequest.newBuilder().uri(URI.create(this.permalink + ".json")).header("User-Agent", RedditStream.USER_AGENT).build(), HttpResponse.BodyHandlers.ofString()).body();
            JSONObject json = new JSONArray(body).getJSONObject(0).getJSONObject("data").getJSONArray("children").getJSONObject(0).getJSONObject("data");
            this.author = json.getString("author");
            this.title = json.getString("title");
            this.selfText = json.getString("selftext");
            this.link = json.getString("url");
            this.score = json.getInt("score");
            this.upvotes = json.getInt("ups");
            this.downvotes = json.getInt("downs");
            this.nsfw = json.getBoolean("over_18");
            this.spoiler = json.getBoolean("spoiler");
            this.quarantine = json.getBoolean("quarantine");
            this.createdAt = json.getLong("created");
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Operation was interrupted.", e);
        }
        catch (IOException e) {
            throw new UncheckedIOException("A IO exception ocurred while updating the object.", e);
        }
        return this;
    }

    public RedditStream getRedditStream() {
        return this.redditStream;
    }

    public Subreddit getSubreddit() {
        return this.subreddit;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSelfText() {
        return this.selfText;
    }

    public String getLink() {
        return this.link;
    }

    public String getPermalink() {
        return this.permalink;
    }

    public boolean isSpoiler() {
        return this.spoiler;
    }

    public boolean isNsfw() {
        return this.nsfw;
    }

    public boolean isQuarantine() {
        return this.quarantine;
    }

    public int getScore() {
        return this.score;
    }

    public int getUpvotes() {
        return this.upvotes;
    }

    public int getDownvotes() {
        return this.downvotes;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }
}

