/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.processmonitor;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import pw.aru.libs.processmonitor.ProcessSnapshot;

public class ProcessMonitor {
    private static final int availableProcessors = Runtime.getRuntime().availableProcessors();
    private static final double MB = 1048576.0;
    private static final double GB = 1.073741824E9;
    private static final OperatingSystemMXBean os = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    private static final ThreadMXBean thread = ManagementFactory.getThreadMXBean();
    private static final Runtime r = Runtime.getRuntime();
    private static final RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
    private long lastSystemTime = runtime.getUptime();
    private double lastProcessCpuTime = os.getProcessCpuTime();

    public static int availableProcessors() {
        return availableProcessors;
    }

    private double processCpuUsage() {
        long systemTime = runtime.getUptime();
        double processCpuTime = os.getProcessCpuTime();
        double cpuUsage = Math.min(99.99, (processCpuTime - this.lastProcessCpuTime) / ((double)(systemTime - this.lastSystemTime) * 10000.0 * (double)availableProcessors));
        this.lastSystemTime = systemTime;
        this.lastProcessCpuTime = processCpuTime;
        return cpuUsage;
    }

    public ProcessSnapshot takeSnapshot() {
        return new ProcessSnapshot(System.currentTimeMillis(), this.processCpuUsage(), os.getSystemCpuLoad(), thread.getThreadCount(), r.freeMemory(), r.totalMemory(), r.maxMemory(), os.getFreePhysicalMemorySize(), os.getTotalPhysicalMemorySize());
    }

    public Future<ProcessSnapshot> snapshotStream(final ScheduledExecutorService service, final long period, final TimeUnit unit, final Consumer<ProcessSnapshot> onSnapshot) {
        return new Future<ProcessSnapshot>(){
            private ProcessSnapshot last;
            private Future<?> future;
            {
                this.future = service.scheduleAtFixedRate(this::updateSnapshot, 0L, period, unit);
            }

            private void updateSnapshot() {
                this.last = ProcessMonitor.this.takeSnapshot();
                onSnapshot.accept(this.last);
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return this.future.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return this.future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return this.future.isDone();
            }

            @Override
            public ProcessSnapshot get() {
                return this.last;
            }

            @Override
            public ProcessSnapshot get(long timeout, TimeUnit unit2) throws InterruptedException {
                Thread.sleep(unit2.toMillis(timeout));
                return this.get();
            }
        };
    }
}

