/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.processmonitor;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.StringJoiner;
import pw.aru.libs.processmonitor.MemoryUnit;

public class ProcessSnapshot {
    private final double cpuUsage;
    private final double systemCpuUsage;
    private final long threadCount;
    private final long freeMemory;
    private final long allocatedMemory;
    private final long maxMemory;
    private final long systemFreeMemory;
    private final long systemMaxMemory;
    private final long systemUsedMemory;
    private final long usedMemory;
    private long timeMillis;

    public ProcessSnapshot(long timeMillis, double cpuUsage, double systemCpuUsage, long threadCount, long freeMemory, long maxMemory, long allocatedMemory, long systemFreeMemory, long systemMaxMemory) {
        this.timeMillis = timeMillis;
        this.cpuUsage = cpuUsage;
        this.freeMemory = freeMemory;
        this.maxMemory = maxMemory;
        this.usedMemory = allocatedMemory - freeMemory;
        this.threadCount = threadCount;
        this.allocatedMemory = allocatedMemory;
        this.systemCpuUsage = systemCpuUsage;
        this.systemFreeMemory = systemFreeMemory;
        this.systemMaxMemory = systemMaxMemory;
        this.systemUsedMemory = systemMaxMemory - freeMemory;
    }

    public long timeMillis() {
        return this.timeMillis;
    }

    public OffsetDateTime time() {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(this.timeMillis), ZoneOffset.UTC);
    }

    public double cpuUsage() {
        return this.cpuUsage;
    }

    public double systemCpuUsage() {
        return this.systemCpuUsage;
    }

    public long threadCount() {
        return this.threadCount;
    }

    public long freeMemory() {
        return this.freeMemory;
    }

    public long usedMemory() {
        return this.usedMemory;
    }

    public long allocatedMemory() {
        return this.allocatedMemory;
    }

    public long maxMemory() {
        return this.maxMemory;
    }

    public long systemFreeMemory() {
        return this.systemFreeMemory;
    }

    public long systemMaxMemory() {
        return this.systemMaxMemory;
    }

    public long systemUsedMemory() {
        return this.systemUsedMemory;
    }

    public double freeMemory(MemoryUnit unit) {
        return MemoryUnit.BYTES.convertTo((double)this.freeMemory, unit);
    }

    public double usedMemory(MemoryUnit unit) {
        return MemoryUnit.BYTES.convertTo((double)this.usedMemory, unit);
    }

    public double allocatedMemory(MemoryUnit unit) {
        return MemoryUnit.BYTES.convertTo((double)this.allocatedMemory, unit);
    }

    public double maxMemory(MemoryUnit unit) {
        return MemoryUnit.BYTES.convertTo((double)this.maxMemory, unit);
    }

    public double systemFreeMemory(MemoryUnit unit) {
        return MemoryUnit.BYTES.convertTo((double)this.systemFreeMemory, unit);
    }

    public double systemMaxMemory(MemoryUnit unit) {
        return MemoryUnit.BYTES.convertTo((double)this.systemMaxMemory, unit);
    }

    public double systemUsedMemory(MemoryUnit unit) {
        return MemoryUnit.BYTES.convertTo((double)this.systemUsedMemory, unit);
    }

    public String toString() {
        return new StringJoiner(", ", "ProcessSnapshot taken at " + this.time() + ": ", "").add("Process CPU usage: " + this.cpuUsage).add("System CPU usage: " + this.systemCpuUsage).add("Process thread count: " + this.threadCount).add("Process free memory: " + this.freeMemory).add("Process allocated memory: " + this.allocatedMemory).add("Process max memory: " + this.maxMemory).add("System free memory: " + this.systemFreeMemory).add("System max memory: " + this.systemMaxMemory).add("System used memory: " + this.systemUsedMemory).toString();
    }
}

