/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.processmonitor;

public enum MemoryUnit {
    BYTES(1L),
    KILOBYTES(1024L),
    MEGABYTES(0x100000L),
    GIGABYTES(0x40000000L),
    TERABYTES(0x10000000000L),
    PETABYTES(0x4000000000000L);

    public static final MemoryUnit B;
    public static final MemoryUnit kB;
    public static final MemoryUnit MB;
    public static final MemoryUnit GB;
    public static final MemoryUnit TB;
    public static final MemoryUnit PB;
    private static final long BYTE_SCALE = 1L;
    private static final long KILO_SCALE = 1024L;
    private static final long MEGA_SCALE = 0x100000L;
    private static final long GIGA_SCALE = 0x40000000L;
    private static final long TERA_SCALE = 0x10000000000L;
    private static final long PETA_SCALE = 0x4000000000000L;
    private final long scale;

    private MemoryUnit(long scale) {
        this.scale = scale;
    }

    public double convertTo(double value, MemoryUnit unit) {
        double scaling = (double)this.scale / (double)unit.scale;
        return value * scaling;
    }

    public long convertTo(long value, MemoryUnit unit) {
        int delta = (unit.ordinal() - this.ordinal()) * 10;
        if (delta > 0) {
            return value >> delta;
        }
        return value << -delta;
    }

    static {
        B = BYTES;
        kB = KILOBYTES;
        MB = MEGABYTES;
        GB = GIGABYTES;
        TB = TERABYTES;
        PB = PETABYTES;
    }
}

