/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.eventpipes.internal;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import pw.aru.libs.eventpipes.api.EventConsumer;
import pw.aru.libs.eventpipes.api.EventExecutor;
import pw.aru.libs.eventpipes.api.EventPipe;
import pw.aru.libs.eventpipes.api.EventPublisher;
import pw.aru.libs.eventpipes.api.EventSubscriber;
import pw.aru.libs.eventpipes.api.EventSubscription;
import pw.aru.libs.eventpipes.api.typed.TypedEventPipe;
import pw.aru.libs.eventpipes.api.typed.TypedEventPublisher;
import pw.aru.libs.eventpipes.api.typed.TypedEventSubscriber;
import pw.aru.libs.eventpipes.internal.DefaultEventPipe;
import pw.aru.libs.eventpipes.internal.Wrapper;

public class DefaultTypedEventPipe
implements TypedEventPipe {
    private final EventExecutor executor;
    private final Map<String, EventPipe<Object>> pipes;

    public DefaultTypedEventPipe(EventExecutor executor) {
        this.executor = executor;
        this.pipes = new ConcurrentHashMap<String, EventPipe<Object>>();
    }

    @Override
    public CompletableFuture<Void> publish(Object value) {
        return CompletableFuture.allOf((CompletableFuture[])this.collectTypes(value.getClass(), new LinkedHashSet<String>()).stream().map(this.pipes::get).filter(Objects::nonNull).map(pipe -> pipe.publish(value)).toArray(CompletableFuture[]::new));
    }

    private Set<String> collectTypes(Class<?> type, Set<String> target) {
        if (type == null) {
            return target;
        }
        target.add(type.getName());
        this.collectTypes(type.getSuperclass(), target);
        for (Class<?> t : type.getInterfaces()) {
            this.collectTypes(t, target);
        }
        return target;
    }

    @Override
    public <T> EventSubscription<T> subscribe(Class<T> type, EventConsumer<T> consumer) {
        return this.pipeOf(type.getName()).subscribe(consumer);
    }

    @Override
    public <T> CompletableFuture<T> first(Class<T> type, Predicate<T> predicate) {
        return this.pipeOf(type.getName()).first(predicate);
    }

    private <T> EventPipe<T> pipeOf(final String type) {
        return this.pipes.computeIfAbsent(type, ignored -> new DefaultEventPipe<Object>(this.executor){

            @Override
            protected void onEmpty() {
                DefaultTypedEventPipe.this.pipes.remove(type);
            }

            @Override
            protected CompletableFuture<?> onExecute(Object event, EventConsumer<Object> consumer) {
                return DefaultTypedEventPipe.this.executor.executeKeyed(type, new DefaultEventPipe.EventRunnable(event, consumer));
            }
        });
    }

    @Override
    public TypedEventSubscriber subscriber() {
        return Wrapper.wrapSubscriber(this);
    }

    @Override
    public TypedEventPublisher publisher() {
        return Wrapper.wrapPublisher(this);
    }

    @Override
    public <T> EventPipe<T> pipe(Class<T> type) {
        return new TypedPipe<T>(type);
    }

    @Override
    public <T> EventSubscriber<T> subscriber(Class<T> type) {
        return Wrapper.wrapSubscriber(this.pipe(type));
    }

    @Override
    public <T> EventPublisher<T> publisher(Class<T> type) {
        return Wrapper.wrapPublisher(this.pipe(type));
    }

    @Override
    public void close() {
        for (EventPipe<Object> pipe : this.pipes.values()) {
            pipe.close();
        }
    }

    class TypedPipe<T>
    implements EventPipe<T> {
        private final Class<T> type;

        TypedPipe(Class<T> type) {
            this.type = type;
        }

        @Override
        public CompletableFuture<Void> publish(Object event) {
            return DefaultTypedEventPipe.this.publish(event);
        }

        @Override
        public EventSubscription<T> subscribe(EventConsumer<T> consumer) {
            return DefaultTypedEventPipe.this.subscribe(this.type, consumer);
        }

        @Override
        public CompletableFuture<T> first(Predicate<T> predicate) {
            return DefaultTypedEventPipe.this.first(this.type, predicate);
        }

        @Override
        public EventSubscriber<T> subscriber() {
            return Wrapper.wrapSubscriber(this);
        }

        @Override
        public EventPublisher<T> publisher() {
            return Wrapper.wrapPublisher(this);
        }

        @Override
        public void close() {
            DefaultTypedEventPipe.this.pipeOf(this.type.getName()).close();
        }
    }
}

